/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.impl.PathAdjuster;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.http.impl.HttpHeadersAdapter;
import org.vertx.java.core.http.impl.MimeMapping;
import org.vertx.java.core.http.impl.ServerConnection;
import org.vertx.java.core.impl.VertxInternal;

public class DefaultHttpServerResponse
implements HttpServerResponse {
    private final VertxInternal vertx;
    private final ServerConnection conn;
    private final HttpResponse response;
    private final HttpVersion version;
    private final boolean keepAlive;
    private int statusCode = 200;
    private String statusMessage = "OK";
    private boolean headWritten;
    private boolean written;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private boolean chunked;
    private boolean closed;
    private ChannelFuture channelFuture;
    private MultiMap headers;
    private LastHttpContent trailing;
    private MultiMap trailers;

    DefaultHttpServerResponse(VertxInternal vertx, ServerConnection conn, HttpRequest request) {
        this.vertx = vertx;
        this.conn = conn;
        this.version = request.getProtocolVersion();
        this.response = new DefaultHttpResponse(this.version, HttpResponseStatus.OK);
        this.keepAlive = this.version == HttpVersion.HTTP_1_1 || this.version == HttpVersion.HTTP_1_0 && "Keep-Alive".equalsIgnoreCase(request.headers().get("Connection"));
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HttpHeadersAdapter(this.response.headers());
        }
        return this.headers;
    }

    @Override
    public MultiMap trailers() {
        if (this.trailers == null) {
            if (this.trailing == null) {
                this.trailing = new DefaultLastHttpContent();
            }
            this.trailers = new HttpHeadersAdapter(this.trailing.trailingHeaders());
        }
        return this.trailers;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    @Override
    public DefaultHttpServerResponse setChunked(boolean chunked) {
        this.checkWritten();
        if (this.version != HttpVersion.HTTP_1_0) {
            this.chunked = chunked;
        }
        return this;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    @Override
    public DefaultHttpServerResponse putHeader(String key, String value) {
        this.checkWritten();
        this.headers().set(key, value);
        return this;
    }

    @Override
    public DefaultHttpServerResponse putHeader(String key, Iterable<String> values) {
        this.checkWritten();
        this.headers().set(key, values);
        return this;
    }

    @Override
    public DefaultHttpServerResponse putTrailer(String key, String value) {
        this.checkWritten();
        this.trailers().set(key, value);
        return this;
    }

    @Override
    public DefaultHttpServerResponse putTrailer(String key, Iterable<String> values) {
        this.checkWritten();
        this.trailers().set(key, values);
        return this;
    }

    @Override
    public HttpServerResponse setWriteQueueMaxSize(int size) {
        this.checkWritten();
        this.conn.doSetWriteQueueMaxSize(size);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        this.checkWritten();
        return this.conn.doWriteQueueFull();
    }

    @Override
    public HttpServerResponse drainHandler(Handler<Void> handler) {
        this.checkWritten();
        this.drainHandler = handler;
        this.conn.handleInterestedOpsChanged();
        return this;
    }

    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.checkWritten();
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        this.checkWritten();
        this.closeHandler = handler;
        return this;
    }

    @Override
    public DefaultHttpServerResponse write(Buffer chunk) {
        ByteBuf buf = chunk.getByteBuf();
        return this.write(buf, null);
    }

    @Override
    public DefaultHttpServerResponse write(String chunk, String enc) {
        return this.write(new Buffer(chunk, enc).getByteBuf(), null);
    }

    @Override
    public DefaultHttpServerResponse write(String chunk) {
        return this.write(new Buffer(chunk).getByteBuf(), null);
    }

    @Override
    public void end(String chunk) {
        this.end(new Buffer(chunk));
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(new Buffer(chunk, enc));
    }

    @Override
    public void end(Buffer chunk) {
        if (!this.chunked && !this.contentLengthSet()) {
            this.headers().set("Content-Length", String.valueOf(chunk.length()));
        }
        ByteBuf buf = chunk.getByteBuf();
        this.end0(buf);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.headWritten) {
                this.closeConnAfterWrite();
            } else {
                this.conn.close();
            }
            this.closed = true;
        }
    }

    @Override
    public void end() {
        this.end0(null);
    }

    private void end0(ByteBuf data) {
        this.checkWritten();
        if (!this.headWritten) {
            this.prepareHeaders();
            DefaultFullHttpResponse resp = data == null ? new DefaultFullHttpResponse(this.response.getProtocolVersion(), this.response.getStatus()) : new DefaultFullHttpResponse(this.response.getProtocolVersion(), this.response.getStatus(), data);
            resp.headers().set(this.response.headers());
            if (this.trailing != null) {
                resp.trailingHeaders().set(this.trailing.trailingHeaders());
            }
            this.channelFuture = this.conn.write(resp);
            this.headWritten = true;
        } else if (data == null) {
            this.channelFuture = this.trailing == null ? this.conn.write(DefaultLastHttpContent.EMPTY_LAST_CONTENT) : this.conn.write(this.trailing);
        } else {
            DefaultLastHttpContent content = new DefaultLastHttpContent(data);
            if (this.trailing != null) {
                content.trailingHeaders().set(this.trailing.trailingHeaders());
            }
            this.channelFuture = this.conn.write(content);
        }
        if (!this.keepAlive) {
            this.closeConnAfterWrite();
        }
        this.written = true;
        this.conn.responseComplete();
    }

    @Override
    public DefaultHttpServerResponse sendFile(String filename) {
        return this.sendFile(filename, null);
    }

    @Override
    public DefaultHttpServerResponse sendFile(String filename, String notFoundResource) {
        if (this.headWritten) {
            throw new IllegalStateException("Head already written");
        }
        this.checkWritten();
        File file = new File(PathAdjuster.adjust(this.vertx, filename));
        if (!file.exists()) {
            if (notFoundResource != null) {
                this.statusCode = HttpResponseStatus.NOT_FOUND.code();
                this.sendFile(notFoundResource, null);
            } else {
                this.sendNotFound();
            }
        } else {
            String ext;
            String contentType;
            int li;
            if (!this.contentLengthSet()) {
                this.putHeader("Content-Length", String.valueOf(file.length()));
            }
            if (!this.contentTypeSet() && (li = filename.lastIndexOf(46)) != -1 && li != filename.length() - 1 && (contentType = MimeMapping.getMimeTypeForExtension(ext = filename.substring(li + 1, filename.length()))) != null) {
                this.putHeader("Content-Type", contentType);
            }
            this.prepareHeaders();
            this.conn.write(this.response);
            this.conn.sendFile(file);
            this.channelFuture = this.conn.write(LastHttpContent.EMPTY_LAST_CONTENT);
            this.written = true;
            this.headWritten = true;
            if (!this.keepAlive) {
                this.closeConnAfterWrite();
            }
            this.conn.responseComplete();
        }
        return this;
    }

    private boolean contentLengthSet() {
        if (this.headers == null) {
            return false;
        }
        return this.headers.contains("Content-Length");
    }

    private boolean contentTypeSet() {
        if (this.headers == null) {
            return false;
        }
        return this.headers.contains("Content-Type");
    }

    private void closeConnAfterWrite() {
        if (this.channelFuture != null) {
            this.channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    DefaultHttpServerResponse.this.conn.close();
                }
            });
        }
    }

    private void sendNotFound() {
        this.statusCode = HttpResponseStatus.NOT_FOUND.code();
        this.putHeader("content-type", "text/html");
        this.end("<html><body>Resource not found</body><html>");
    }

    void handleDrained() {
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        }
    }

    void handleClosed() {
        if (this.closeHandler != null) {
            this.closeHandler.handle(null);
        }
    }

    private void checkWritten() {
        if (this.written) {
            throw new IllegalStateException("Response has already been written");
        }
    }

    private void prepareHeaders() {
        HttpResponseStatus status = this.statusMessage == null ? HttpResponseStatus.valueOf((int)this.statusCode) : new HttpResponseStatus(this.statusCode, this.statusMessage);
        this.response.setStatus(status);
        if (this.version == HttpVersion.HTTP_1_0 && this.keepAlive) {
            this.response.headers().set("Connection", (Object)"Keep-Alive");
        }
        if (this.chunked) {
            this.response.headers().set("Transfer-Encoding", (Object)"chunked");
        } else if (this.version != HttpVersion.HTTP_1_0 && !this.contentLengthSet()) {
            this.response.headers().set("Content-Length", (Object)"0");
        }
    }

    private DefaultHttpServerResponse write(ByteBuf chunk, Handler<AsyncResult<Void>> doneHandler) {
        this.checkWritten();
        if (this.version != HttpVersion.HTTP_1_0 && !this.chunked && !this.contentLengthSet()) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        if (!this.headWritten) {
            this.prepareHeaders();
            this.conn.queueForWrite(this.response);
            this.headWritten = true;
        }
        DefaultHttpContent content = new DefaultHttpContent(chunk);
        this.channelFuture = this.conn.write(content);
        this.conn.addFuture(doneHandler, this.channelFuture);
        return this;
    }
}

