/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import java.util.Map;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.core.sockjs.impl.BaseTransport;
import org.vertx.java.core.sockjs.impl.Session;

class EventSourceTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(EventSourceTransport.class);

    EventSourceTransport(VertxInternal vertx, RouteMatcher rm, String basePath, Map<String, Session> sessions, final JsonObject config, final Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, config);
        String eventSourceRE = basePath + "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/" + "eventsource";
        rm.getWithRegEx(eventSourceRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest req) {
                if (log.isTraceEnabled()) {
                    log.trace("EventSource transport, get: " + req.uri());
                }
                String sessionID = req.params().get("param0");
                Session session = EventSourceTransport.this.getSession(config.getLong("session_timeout"), config.getLong("heartbeat_period"), sessionID, sockHandler);
                session.register(new EventSourceListener(config.getInteger("max_bytes_streaming"), req, session));
            }
        });
    }

    private class EventSourceListener
    extends BaseTransport.BaseListener {
        final int maxBytesStreaming;
        final HttpServerRequest req;
        final Session session;
        boolean headersWritten;
        int bytesSent;
        boolean closed;

        EventSourceListener(int maxBytesStreaming, HttpServerRequest req, Session session) {
            this.maxBytesStreaming = maxBytesStreaming;
            this.req = req;
            this.session = session;
            this.addCloseHandler(req.response(), session);
        }

        @Override
        public void sendFrame(String body) {
            if (log.isTraceEnabled()) {
                log.trace("EventSource, sending frame");
            }
            if (!this.headersWritten) {
                this.req.response().headers().set("Content-Type", "text/event-stream; charset=UTF-8");
                BaseTransport.setNoCacheHeaders(this.req);
                BaseTransport.setJSESSIONID(EventSourceTransport.this.config, this.req);
                this.req.response().setChunked(true);
                this.req.response().write("\r\n");
                this.headersWritten = true;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("data: ");
            sb.append(body);
            sb.append("\r\n\r\n");
            Buffer buff = new Buffer(sb.toString());
            this.req.response().write(buff);
            this.bytesSent += buff.length();
            if (this.bytesSent >= this.maxBytesStreaming) {
                if (log.isTraceEnabled()) {
                    log.trace("More than maxBytes sent so closing connection");
                }
                this.close();
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.session.resetListener(false);
                    this.req.response().end();
                    this.req.response().close();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.closed = true;
            }
        }
    }
}

