/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.BufUtil;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerUtil;
import io.netty.channel.ChannelInboundMessageHandler;
import java.util.Map;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.ConnectionBase;
import org.vertx.java.core.net.impl.VertxStateHandler;

public abstract class VertxHttpHandler<C extends ConnectionBase>
extends VertxStateHandler<C>
implements ChannelHandlerUtil.SingleInboundMessageHandler<Object>,
ChannelInboundMessageHandler<Object> {
    private final VertxInternal vertx;

    protected VertxHttpHandler(VertxInternal vertx, Map<Channel, C> connectionMap) {
        super(vertx, connectionMap);
        this.vertx = vertx;
    }

    public MessageBuf<Object> newInboundBuffer(ChannelHandlerContext channelHandlerContext) throws Exception {
        return Unpooled.messageBuffer();
    }

    public void inboundBufferUpdated(ChannelHandlerContext channelHandlerContext) throws Exception {
        ChannelHandlerUtil.handleInboundBufferUpdated((ChannelHandlerContext)channelHandlerContext, (ChannelHandlerUtil.SingleInboundMessageHandler)this);
    }

    public boolean acceptInboundMessage(Object o) throws Exception {
        return true;
    }

    public boolean beginMessageReceived(ChannelHandlerContext channelHandlerContext) throws Exception {
        return true;
    }

    public void endMessageReceived(ChannelHandlerContext channelHandlerContext) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(final ChannelHandlerContext chctx, final Object msg) throws Exception {
        final Channel ch = chctx.channel();
        final ConnectionBase connection = (ConnectionBase)this.connectionMap.get(ch);
        if (connection != null) {
            DefaultContext context = this.getContext(connection);
            if (context.isOnCorrectWorker(ch.eventLoop())) {
                try {
                    this.vertx.setContext(context);
                    context.startExecute();
                    this.doMessageReceived(connection, chctx, msg);
                }
                catch (Throwable t) {
                    context.reportException(t);
                }
                finally {
                    context.endExecute();
                }
            } else {
                BufUtil.retain((Object)msg);
                context.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            VertxHttpHandler.this.doMessageReceived(connection, chctx, msg);
                        }
                        catch (Exception e) {
                            ch.pipeline().fireExceptionCaught((Throwable)e);
                        }
                        finally {
                            BufUtil.release((Object)msg);
                        }
                    }
                });
            }
        } else {
            this.doMessageReceived(connection, chctx, msg);
        }
    }

    protected abstract void doMessageReceived(C var1, ChannelHandlerContext var2, Object var3) throws Exception;
}

