/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.http.impl.AbstractConnection;
import org.vertx.java.core.http.impl.ws.DefaultWebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.impl.VertxInternal;

public class WebSocketImplBase {
    private final String textHandlerID;
    private final String binaryHandlerID;
    private final VertxInternal vertx;
    protected final AbstractConnection conn;
    protected Handler<Buffer> dataHandler;
    protected Handler<Void> drainHandler;
    protected Handler<Throwable> exceptionHandler;
    protected Handler<Void> closeHandler;
    protected Handler<Void> endHandler;
    protected Handler<Message<Buffer>> binaryHandler;
    protected Handler<Message<String>> textHandler;
    protected boolean closed;

    protected WebSocketImplBase(VertxInternal vertx, AbstractConnection conn) {
        this.vertx = vertx;
        this.textHandlerID = UUID.randomUUID().toString();
        this.binaryHandlerID = UUID.randomUUID().toString();
        this.conn = conn;
        this.binaryHandler = new Handler<Message<Buffer>>(){

            @Override
            public void handle(Message<Buffer> msg) {
                WebSocketImplBase.this.writeBinaryFrameInternal(msg.body());
            }
        };
        vertx.eventBus().registerLocalHandler(this.binaryHandlerID, this.binaryHandler);
        this.textHandler = new Handler<Message<String>>(){

            @Override
            public void handle(Message<String> msg) {
                WebSocketImplBase.this.writeTextFrameInternal(msg.body());
            }
        };
        vertx.eventBus().registerLocalHandler(this.textHandlerID, this.textHandler);
    }

    public String binaryHandlerID() {
        return this.binaryHandlerID;
    }

    public String textHandlerID() {
        return this.textHandlerID;
    }

    public boolean writeQueueFull() {
        this.checkClosed();
        return this.conn.doWriteQueueFull();
    }

    public void close() {
        this.checkClosed();
        this.conn.close();
        this.cleanupHandlers();
    }

    protected void writeBinaryFrameInternal(Buffer data) {
        ByteBuf buf = data.getByteBuf();
        if (data.isWrapper()) {
            buf.retain();
        }
        DefaultWebSocketFrame frame = new DefaultWebSocketFrame(WebSocketFrame.FrameType.BINARY, buf);
        this.writeFrame(frame);
    }

    protected void writeTextFrameInternal(String str) {
        DefaultWebSocketFrame frame = new DefaultWebSocketFrame(str);
        this.writeFrame(frame);
    }

    private void cleanupHandlers() {
        if (!this.closed) {
            this.vertx.eventBus().unregisterHandler(this.binaryHandlerID, this.binaryHandler);
            this.vertx.eventBus().unregisterHandler(this.textHandlerID, this.textHandler);
            this.closed = true;
        }
    }

    protected void writeFrame(WebSocketFrame frame) {
        this.checkClosed();
        this.conn.write(frame);
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("WebSocket is closed");
        }
    }

    void handleFrame(WebSocketFrame frame) {
        if (this.dataHandler != null) {
            Buffer buff = new Buffer(frame.getBinaryData());
            this.dataHandler.handle(buff);
        }
    }

    void writable() {
        if (this.drainHandler != null) {
            Handler<Void> dh = this.drainHandler;
            this.drainHandler = null;
            dh.handle(null);
        }
    }

    void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        }
    }

    void handleClosed() {
        this.cleanupHandlers();
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
        if (this.closeHandler != null) {
            this.closeHandler.handle(null);
        }
    }
}

