/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Objects;

@DataObject
public class ConfigChange {
    private JsonObject previousConfiguration;
    private JsonObject newConfiguration;

    public ConfigChange(JsonObject prevConf, JsonObject newConf) {
        this.setPreviousConfiguration(prevConf);
        this.setNewConfiguration(newConf);
    }

    public JsonObject getPreviousConfiguration() {
        return this.previousConfiguration;
    }

    public ConfigChange setPreviousConfiguration(JsonObject conf) {
        this.previousConfiguration = conf == null ? new JsonObject() : conf;
        return this;
    }

    public JsonObject getNewConfiguration() {
        return this.newConfiguration;
    }

    public ConfigChange setNewConfiguration(JsonObject conf) {
        this.newConfiguration = conf == null ? new JsonObject() : conf;
        return this;
    }

    public ConfigChange() {
        this.newConfiguration = new JsonObject();
        this.previousConfiguration = new JsonObject();
    }

    public ConfigChange(ConfigChange other) {
        this.previousConfiguration = other.previousConfiguration.copy();
        this.newConfiguration = other.newConfiguration.copy();
    }

    public ConfigChange(JsonObject json) {
        Objects.requireNonNull(json);
        this.setNewConfiguration(json.getJsonObject("newConfiguration", new JsonObject()));
        this.setPreviousConfiguration(json.getJsonObject("previousConfiguration", new JsonObject()));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("newConfiguration", (Object)this.newConfiguration);
        json.put("previousConfiguration", (Object)this.previousConfiguration);
        return json;
    }
}

