/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.generators.mvel;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.vertx.codegen.CodeGenProcessor;
import io.vertx.codegen.Generator;
import io.vertx.codegen.GeneratorLoader;
import io.vertx.codegen.generators.mvel.MvelCodeGenerator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;

public class MvelCodeGeneratorLoader
implements GeneratorLoader {
    private static final JsonFactory factory = new JsonFactory();

    @Override
    public Stream<Generator<?>> loadGenerators(ProcessingEnvironment processingEnv) {
        ArrayList<MvelCodeGenerator> generators = new ArrayList<MvelCodeGenerator>();
        Enumeration<Object> descriptors = Collections.emptyEnumeration();
        try {
            descriptors = CodeGenProcessor.class.getClassLoader().getResources("codegen.json");
        }
        catch (IOException ignore) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not load code generator descriptors");
        }
        HashSet<String> templates = new HashSet<String>();
        while (descriptors.hasMoreElements()) {
            URL descriptor = (URL)descriptors.nextElement();
            try {
                JsonParser parser = factory.createParser(descriptor);
                Throwable throwable = null;
                try {
                    List<MvelCodeGenerator> parsed = this.parseContent(parser);
                    for (MvelCodeGenerator gen : parsed) {
                        if (templates.contains(gen.templateFilename)) continue;
                        templates.add(gen.templateFilename);
                        generators.add(gen);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (parser == null) continue;
                    if (throwable != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    parser.close();
                }
            }
            catch (Exception e) {
                String msg = "Could not load code generator " + descriptor;
                CodeGenProcessor.log.log(Level.SEVERE, msg, e);
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            }
        }
        return generators.stream();
    }

    private List<MvelCodeGenerator> parseContent(JsonParser parser) throws IOException {
        List<MvelCodeGenerator> generators = null;
        String name = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String tokenName = parser.getCurrentName();
            if ("name".equals(tokenName)) {
                parser.nextToken();
                name = parser.getValueAsString();
                continue;
            }
            if (!"generators".equals(tokenName)) continue;
            parser.nextToken();
            generators = this.parseGenerators(parser);
        }
        for (MvelCodeGenerator generator : generators) {
            generator.name = name;
        }
        return generators;
    }

    private List<MvelCodeGenerator> parseGenerators(JsonParser parser) throws IOException {
        ArrayList<MvelCodeGenerator> generators = new ArrayList<MvelCodeGenerator>();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            generators.add(this.parseGenerator(parser));
        }
        return generators;
    }

    private MvelCodeGenerator parseGenerator(JsonParser parser) throws IOException {
        MvelCodeGenerator gen = new MvelCodeGenerator();
        HashSet<String> kinds = new HashSet<String>();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String tokenName = parser.getCurrentName();
            if ("kind".equals(tokenName)) {
                parser.nextToken();
                if (parser.currentToken() == JsonToken.START_ARRAY) {
                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                        kinds.add(parser.getValueAsString());
                    }
                    continue;
                }
                kinds.add(parser.getValueAsString());
                continue;
            }
            if ("incremental".equals(tokenName)) {
                parser.nextToken();
                gen.incremental = parser.getValueAsBoolean();
                continue;
            }
            if ("filename".equals(tokenName)) {
                parser.nextToken();
                gen.filename = parser.getValueAsString();
                continue;
            }
            if (!"templateFilename".equals(tokenName)) continue;
            parser.nextToken();
            gen.templateFilename = parser.getValueAsString();
        }
        gen.kinds = kinds;
        return gen;
    }
}

