/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.overloadcheck;

import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.overloadcheck.SimpleMethod;
import io.vertx.codegen.overloadcheck.SimpleParam;
import io.vertx.codegen.overloadcheck.SimpleType;
import io.vertx.codegen.type.DataObjectTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MethodOverloadChecker {
    public static final MethodOverloadChecker INSTANCE;
    private final Map<String, Map<String, Set<String>>> typeMappingsMap = new HashMap<String, Map<String, Set<String>>>();

    public MethodOverloadChecker() {
        this.loadTypeMappings();
    }

    public MethodOverloadChecker(Properties props) {
        this.loadTypeMappings(props);
    }

    public void checkAmbiguous(Stream<MethodInfo> meths) {
        this.checkAmbiguousSimple(this.convert(meths).collect(Collectors.toList()));
    }

    public void checkAmbiguousSimple(List<SimpleMethod> meths) {
        ArrayList<SimpleMethod> methods = new ArrayList<SimpleMethod>(meths);
        HashMap<Integer, ArrayList<SimpleMethod>> byNumParams = new HashMap<Integer, ArrayList<SimpleMethod>>();
        for (SimpleMethod simpleMethod : methods) {
            int numParams = simpleMethod.params.size();
            ArrayList<SimpleMethod> list = (ArrayList<SimpleMethod>)byNumParams.get(numParams);
            if (list == null) {
                list = new ArrayList<SimpleMethod>();
                byNumParams.put(numParams, list);
            }
            list.add(simpleMethod);
        }
        for (Map.Entry entry : byNumParams.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() == 1) continue;
            for (Map.Entry<String, Map<String, Set<String>>> mappingEntry : this.typeMappingsMap.entrySet()) {
                this.checkMethodList(mappingEntry.getKey(), list, mappingEntry.getValue());
            }
        }
    }

    private Stream<SimpleMethod> convert(Stream<MethodInfo> meths) {
        return meths.map(meth -> {
            ArrayList<SimpleParam> simpleParams = new ArrayList<SimpleParam>();
            for (ParamInfo param : meth.getParams()) {
                TypeInfo type = param.getType() instanceof DataObjectTypeInfo ? ((DataObjectTypeInfo)param.getType()).getTargetJsonType() : param.getType();
                simpleParams.add(new SimpleParam(param.getName(), type.getKind(), param.isNullable(), type.getName()));
            }
            return new SimpleMethod(meth.getName(), simpleParams);
        });
    }

    private void checkMethodList(String targetLang, List<SimpleMethod> meths, Map<String, Set<String>> typeMapping) {
        ArrayList<List> paramsTypesList = new ArrayList<List>();
        for (SimpleMethod meth : meths) {
            List paramTypes = this.convertToLangParamTypes(meth, typeMapping);
            paramsTypesList.add(paramTypes);
        }
        int index1 = 0;
        for (List paramTypes : paramsTypesList) {
            int index2 = 0;
            for (List paramTypesToCompare : paramsTypesList) {
                if (index1 != index2) {
                    boolean matched = true;
                    for (int i = 0; i < paramTypes.size(); ++i) {
                        SimpleType paramTypeToCompare;
                        SimpleType paramType = (SimpleType)paramTypes.get(i);
                        if (paramType.matches(paramTypeToCompare = (SimpleType)paramTypesToCompare.get(i))) continue;
                        matched = false;
                        break;
                    }
                    if (matched) {
                        SimpleMethod clashing1 = meths.get(index1);
                        SimpleMethod clashing2 = meths.get(index2);
                        String msg = "Failed to generate because it would be impossible in target language " + targetLang + " at runtime to resolve which of the following overloaded methods to call in the Java API: " + clashing1 + " and " + clashing2;
                        throw new IllegalArgumentException(msg);
                    }
                }
                ++index2;
            }
            ++index1;
        }
    }

    private List<SimpleType> convertToLangParamTypes(SimpleMethod meth, Map<String, Set<String>> typeMapping) {
        ArrayList<SimpleType> langParamTypes = new ArrayList<SimpleType>();
        for (SimpleParam param : meth.params) {
            String lhs;
            Set<String> langType = typeMapping.get(param.classKind.toString());
            if (langType == null && (langType = typeMapping.get(lhs = param.classKind.toString() + "." + param.typeName)) == null) {
                throw new IllegalStateException("No type mapping found for param type " + lhs);
            }
            langParamTypes.add(new SimpleType(langType, param.nullable));
        }
        return langParamTypes;
    }

    private void loadTypeMappings() {
        try (InputStream is = MethodOverloadChecker.class.getClassLoader().getResourceAsStream("lang-type-mapping.properties");){
            Properties props = new Properties();
            props.load(is);
            this.loadTypeMappings(props);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void loadTypeMappings(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String lhs = (String)entry.getKey();
            String rhs = (String)entry.getValue();
            int pos = lhs.indexOf(46);
            String lang = lhs.substring(0, pos);
            String key = lhs.substring(pos + 1);
            Map<String, Set<String>> typeMapping = this.typeMappingsMap.get(lang);
            if (typeMapping == null) {
                typeMapping = new HashMap<String, Set<String>>();
                this.typeMappingsMap.put(lang, typeMapping);
            }
            HashSet<String> types = new HashSet<String>(Arrays.asList(rhs.split("\\s*,\\s*")));
            typeMapping.put(key, types);
        }
    }

    static {
        MethodOverloadChecker checker = new MethodOverloadChecker(new Properties());
        try {
            checker = new MethodOverloadChecker();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        INSTANCE = checker;
    }
}

