/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.EnumModel;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.Model;
import io.vertx.codegen.ModelProvider;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.ModuleModel;
import io.vertx.codegen.PackageModel;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.type.AnnotationValueInfo;
import io.vertx.codegen.type.AnnotationValueInfoFactory;
import io.vertx.codegen.type.TypeMirrorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class CodeGen {
    private static final List<ModelProvider> PROVIDERS;
    private static final Logger logger;
    static final Map<ProcessingEnvironment, ClassLoader> loaderMap;
    private final Map<String, Map<String, Map.Entry<TypeElement, Model>>> models = new HashMap<String, Map<String, Map.Entry<TypeElement, Model>>>();
    private final Set<TypeElement> all = new HashSet<TypeElement>();
    private final HashMap<String, PackageElement> modules = new HashMap();
    private final Elements elementUtils;
    private final Types typeUtils;

    public CodeGen(ProcessingEnvironment env, RoundEnvironment round, ClassLoader loader) {
        this.elementUtils = env.getElementUtils();
        this.typeUtils = env.getTypeUtils();
        loaderMap.put(env, loader);
        Predicate<Element> implFilter = elt -> {
            PackageElement pkg;
            try {
                pkg = this.elementUtils.getPackageOf((Element)elt);
            }
            catch (NullPointerException e) {
                return true;
            }
            String fqn = pkg.getQualifiedName().toString();
            if (fqn.contains(".impl.") || fqn.endsWith(".impl")) {
                logger.warning("Processed element " + elt + " is in an implementation package");
                return false;
            }
            return true;
        };
        round.getRootElements().stream().filter(implFilter).filter(elt -> elt instanceof TypeElement).map(elt -> (TypeElement)elt).forEach(te -> {
            for (ModelProvider provider : PROVIDERS) {
                Model model = provider.getModel(env, (TypeElement)te);
                if (model == null) continue;
                String kind = model.getKind();
                this.all.add((TypeElement)te);
                Map map = this.models.computeIfAbsent(kind, a -> new HashMap());
                ModelEntry entry = new ModelEntry((Element)te, () -> model, null);
                map.put(Helper.getNonGenericType(te.asType().toString()), entry);
            }
        });
        round.getElementsAnnotatedWith(ModuleGen.class).stream().map(element -> (PackageElement)element).forEach(element -> this.modules.put(element.getQualifiedName().toString(), (PackageElement)element));
    }

    public Stream<Map.Entry<? extends Element, ? extends Model>> getModels() {
        Stream<Object> s = Stream.empty();
        for (Map<String, Map.Entry<TypeElement, Model>> m : this.models.values()) {
            s = Stream.concat(s, m.values().stream());
        }
        return Stream.concat(s, Stream.concat(this.getModuleModels(), this.getPackageModels()));
    }

    private Stream<Map.Entry<PackageElement, PackageModel>> getPackageModels() {
        return this.all.stream().map(this.elementUtils::getPackageOf).distinct().map(element -> new ModelEntry((Element)element, () -> new PackageModel(element.getQualifiedName().toString(), ModuleInfo.resolve(this.elementUtils, element)), null));
    }

    private Stream<Map.Entry<PackageElement, ModuleModel>> getModuleModels() {
        return this.modules.entrySet().stream().map(entry -> new ModelEntry((Element)entry.getValue(), () -> this.getModuleModel((String)entry.getKey()), null));
    }

    public ModuleModel getModuleModel(String modulePackage) {
        PackageElement element = this.modules.get(modulePackage);
        ModuleGen annotation = element.getAnnotation(ModuleGen.class);
        String moduleName = annotation.name();
        if (moduleName.isEmpty()) {
            throw new GenException(element, "A module name cannot be empty");
        }
        try {
            Case.KEBAB.parse(moduleName);
        }
        catch (IllegalArgumentException e) {
            throw new GenException(element, "Module name '" + moduleName + "' does not follow the snake case format (dash separated name)");
        }
        String groupPackage = annotation.groupPackage();
        if (groupPackage.equals("")) {
            groupPackage = modulePackage;
        } else if (!modulePackage.startsWith(groupPackage)) {
            throw new GenException(element, "A module package (" + modulePackage + ") must be prefixed by the group package (" + groupPackage + ")");
        }
        try {
            Case.QUALIFIED.parse(groupPackage);
        }
        catch (Exception e) {
            throw new GenException(element, "Invalid group package name " + groupPackage);
        }
        ModuleInfo info = new ModuleInfo(modulePackage, moduleName, groupPackage);
        AnnotationValueInfoFactory annotationFactory = new AnnotationValueInfoFactory(new TypeMirrorFactory(this.elementUtils, this.typeUtils));
        List<AnnotationValueInfo> annotationValueInfos = element.getAnnotationMirrors().stream().map(annotationFactory::processAnnotation).collect(Collectors.toList());
        return new ModuleModel(element, info, annotationValueInfos);
    }

    public PackageModel getPackageModel(String fqn) {
        return this.getPackageModels().filter(pkg -> ((PackageModel)pkg.getValue()).getFqn().equals(fqn)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public Model getModel(String fqcn, String kind) {
        Map<String, Map.Entry<TypeElement, Model>> map = this.models.get(kind);
        if (map == null) {
            throw new IllegalArgumentException("Source for " + fqcn + " not found");
        }
        Map.Entry<TypeElement, Model> entry = map.get(fqcn);
        if (entry == null) {
            throw new IllegalArgumentException("Source for " + fqcn + " not found");
        }
        return entry.getValue();
    }

    public ClassModel getClassModel(String fqcn) {
        return (ClassModel)this.getModel(fqcn, "class");
    }

    public EnumModel getEnumModel(String fqcn) {
        return (EnumModel)this.getModel(fqcn, "enum");
    }

    public DataObjectModel getDataObjectModel(String fqcn) {
        return (DataObjectModel)this.getModel(fqcn, "dataObject");
    }

    static {
        ArrayList<ModelProvider> list = new ArrayList<ModelProvider>();
        list.add(ModelProvider.CLASS);
        list.add(ModelProvider.DATA_OBJECT);
        list.add(ModelProvider.ENUM);
        try {
            ServiceLoader<ModelProvider> loader = ServiceLoader.load(ModelProvider.class, ModelProvider.class.getClassLoader());
            for (ModelProvider aLoader : loader) {
                list.add(aLoader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PROVIDERS = list;
        logger = Logger.getLogger(CodeGen.class.getName());
        loaderMap = new WeakHashMap<ProcessingEnvironment, ClassLoader>();
    }

    private static class ModelEntry<E extends Element, M extends Model>
    implements Map.Entry<E, M> {
        private final E key;
        private final Supplier<M> supplier;
        private M value;

        private ModelEntry(E key, Supplier<M> supplier) {
            this.key = key;
            this.supplier = supplier;
        }

        @Override
        public E getKey() {
            return this.key;
        }

        @Override
        public M getValue() {
            if (this.value == null) {
                this.value = (Model)this.supplier.get();
                this.value.process();
            }
            return this.value;
        }

        @Override
        public M setValue(M value) {
            throw new UnsupportedOperationException();
        }

        /* synthetic */ ModelEntry(Element x0, Supplier x1, 1 x2) {
            this(x0, x1);
        }
    }
}

