/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.type.TypeNameTranslator;
import javax.lang.model.element.PackageElement;
import javax.lang.model.util.Elements;

public class ModuleInfo {
    private final String packageName;
    private final String name;
    private final String groupPackage;

    public ModuleInfo(String packageName, String name, String groupPackage) {
        this.packageName = packageName;
        this.name = name;
        this.groupPackage = groupPackage;
    }

    public static ModuleInfo resolve(Elements elementUtils, PackageElement pkgElt) {
        while (pkgElt != null) {
            ModuleGen annotation = pkgElt.getAnnotation(ModuleGen.class);
            if (annotation != null) {
                return new ModuleInfo(pkgElt.getQualifiedName().toString(), annotation.name(), annotation.groupPackage());
            }
            String pkgQN = pkgElt.getQualifiedName().toString();
            int pos = pkgQN.lastIndexOf(46);
            if (pos == -1) break;
            pkgElt = elementUtils.getPackageElement(pkgQN.substring(0, pos));
        }
        return null;
    }

    public String getGroupPackage() {
        return this.groupPackage;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String translatePackageName(String lang) {
        return this.translateQualifiedName(this.packageName, lang);
    }

    public String translateQualifiedName(String qualifiedName, String lang) {
        return TypeNameTranslator.hierarchical(lang).translate(this, qualifiedName);
    }

    public String getName() {
        return this.name;
    }

    public String getName(Case _case) {
        return _case.format(Case.KEBAB.parse(this.name));
    }
}

