/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.ClassEnumerator;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.CodeGen;
import io.vertx.codegen.Compiler;
import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.Model;
import io.vertx.codegen.ModuleModel;
import io.vertx.codegen.PackageModel;
import io.vertx.codegen.ProxyModel;
import io.vertx.codegen.Template;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenModule;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.VertxGen;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;

public class Generator {
    Template template;
    HashMap<String, String> options = new HashMap();
    DiagnosticCollector<JavaFileObject> collector = new DiagnosticCollector();

    public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
        return this.collector.getDiagnostics();
    }

    public void setOption(String name, String value) {
        this.options.put(name, value);
    }

    public void validatePackage(String packageName, Function<String, Boolean> packageMatcher) throws Exception {
        this.genAndApply(packageName, packageMatcher, null, null, false);
    }

    public void genAndApply(String packageName, Function<String, Boolean> packageMatcher, Function<Class, String> outputFileFunction, String templateFileName) throws Exception {
        this.genAndApply(packageName, packageMatcher, outputFileFunction, templateFileName, true);
    }

    public void genAndApply(Class clazz, Function<Class, String> outputFileFunction, String templateName) throws Exception {
        ClassModel model = this.generateClass(clazz, new Class[0]);
        this.applyTemplate(model, outputFileFunction.apply(clazz), templateName);
    }

    private void applyTemplate(ClassModel model, String outputFileName, String templateName) throws Exception {
        if (this.template != null && !templateName.equals(this.template.getName())) {
            this.template = null;
        }
        if (this.template == null) {
            this.template = new Template(templateName);
            this.template.setOptions(this.options);
        }
        this.template.apply((Model)model, outputFileName);
    }

    private void genAndApply(String packageName, Function<String, Boolean> packageMatcher, Function<Class, String> outputFileFunction, String templateFileName, boolean apply) throws Exception {
        ArrayList<Class<?>> classes = ClassEnumerator.getClassesForPackage(packageName, packageMatcher);
        ArrayList<Class> generableClasses = new ArrayList<Class>();
        for (Class clazz : classes) {
            if (!clazz.isInterface() || clazz.getAnnotation(VertxGen.class) == null) continue;
            generableClasses.add(clazz);
        }
        for (Class clazz : generableClasses) {
            Generator gen = new Generator();
            ClassModel model = gen.generateClass(clazz, generableClasses.toArray(new Class[generableClasses.size()]));
            if (!apply) continue;
            this.applyTemplate(model, outputFileFunction.apply(clazz), templateFileName);
        }
    }

    public PackageModel generatePackage(Class clazz) throws Exception {
        URL url = clazz.getClassLoader().getResource(clazz.getName().replace('.', '/') + ".java");
        File f = new File(url.toURI());
        MyProcessor processor = new MyProcessor(codegen -> codegen.getPackageModel(clazz.getPackage().getName()));
        Compiler compiler = new Compiler(processor, this.collector);
        compiler.compile(f);
        return (PackageModel)processor.result;
    }

    public ModuleModel generateModule(ClassLoader loader, String packageFqn) throws Exception {
        URL url = loader.getResource(packageFqn.replace('.', '/') + "/package-info.java");
        File f = new File(url.toURI());
        MyProcessor processor = new MyProcessor(codegen -> codegen.getModuleModel(packageFqn));
        Compiler compiler = new Compiler(processor, this.collector);
        compiler.compile(f);
        return (ModuleModel)processor.result;
    }

    public DataObjectModel generateDataObject(Class c, Class ... rest) throws Exception {
        return this.generateClass((CodeGen codegen) -> codegen.getDataObjectModel(c.getCanonicalName()), c, rest);
    }

    public ClassModel generateClass(Class c, Class ... rest) throws Exception {
        return this.generateClass((CodeGen codegen) -> codegen.getClassModel(c.getCanonicalName()), c, rest);
    }

    public ProxyModel generateProxyModel(Class c, Class ... rest) throws Exception {
        return this.generateClass((CodeGen codegen) -> codegen.getProxyModel(c.getCanonicalName()), c, rest);
    }

    public <M> M generateClass(Function<CodeGen, M> f, Class c, Class ... rest) throws Exception {
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(c);
        Collections.addAll(types, rest);
        String className = c.getCanonicalName();
        MyProcessor processor = new MyProcessor(f);
        Compiler compiler = new Compiler(processor, this.collector);
        compiler.compile(types);
        if (processor.result == null) {
            throw new IllegalArgumentException(className + " not processed.");
        }
        return (M)processor.result;
    }

    private class MyProcessor<R>
    implements Processor {
        private ProcessingEnvironment env;
        private final Function<CodeGen, R> f;
        private R result;

        @Override
        public Set<String> getSupportedOptions() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getSupportedAnnotationTypes() {
            HashSet<String> set = new HashSet<String>();
            set.add(ProxyGen.class.getCanonicalName());
            set.add(VertxGen.class.getCanonicalName());
            set.add(DataObject.class.getCanonicalName());
            set.add(GenModule.class.getCanonicalName());
            return set;
        }

        @Override
        public SourceVersion getSupportedSourceVersion() {
            return SourceVersion.RELEASE_8;
        }

        private MyProcessor(Function<CodeGen, R> f) {
            this.f = f;
        }

        @Override
        public void init(ProcessingEnvironment processingEnv) {
            this.env = processingEnv;
        }

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            if (!roundEnv.processingOver()) {
                CodeGen codegen = new CodeGen(this.env, roundEnv);
                this.result = this.f.apply(codegen);
            }
            return true;
        }

        @Override
        public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
            return Collections.emptyList();
        }
    }
}

