/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Variance;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;

public abstract class TypeParamInfo {
    protected final int index;
    protected final String name;

    static TypeParamInfo create(TypeVariable typeVariable) {
        Object decl = typeVariable.getGenericDeclaration();
        TypeVariable<?>[] typeParams = decl.getTypeParameters();
        for (int index = 0; index < typeParams.length; ++index) {
            if (!typeParams[index].equals(typeVariable)) continue;
            if (decl instanceof java.lang.Class) {
                java.lang.Class classDecl = (java.lang.Class)decl;
                return new Class(classDecl.getName(), index, typeVariable.getName(), Collections.emptySet());
            }
            if (decl instanceof java.lang.reflect.Method) {
                java.lang.reflect.Method methodDecl = (java.lang.reflect.Method)decl;
                return new Method(methodDecl.getDeclaringClass().getName(), methodDecl.getName(), index, typeVariable.getName());
            }
            throw new UnsupportedOperationException();
        }
        throw new AssertionError();
    }

    static TypeParamInfo create(TypeParameterElement paramElt) {
        Parameterizable genericElt = (Parameterizable)paramElt.getGenericElement();
        int index = genericElt.getTypeParameters().indexOf(paramElt);
        switch (genericElt.getKind()) {
            case INTERFACE: {
                TypeElement typeElt = (TypeElement)genericElt;
                return new Class(typeElt.getQualifiedName().toString(), index, paramElt.getSimpleName().toString(), Collections.emptySet());
            }
            case METHOD: {
                ExecutableElement methodElt = (ExecutableElement)genericElt;
                TypeElement typeElt = (TypeElement)methodElt.getEnclosingElement();
                return new Method(typeElt.getQualifiedName().toString(), methodElt.getSimpleName().toString(), index, paramElt.getSimpleName().toString());
            }
        }
        throw new UnsupportedOperationException((Object)((Object)genericElt.getKind()) + "");
    }

    public TypeParamInfo(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public static class Method
    extends TypeParamInfo {
        private final String typeName;
        private final String methodName;

        public Method(String typeName, String methodName, int index, String name) {
            super(index, name);
            this.typeName = typeName;
            this.methodName = methodName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Method) {
                Method that = (Method)obj;
                return this.typeName.equals(that.typeName) && this.methodName.equals(that.methodName) && this.index == that.getIndex();
            }
            return false;
        }

        public String toString() {
            return "TypeParamInfo.Method[name=" + this.name + ",typeName=" + this.typeName + ",methodName" + this.methodName + "]";
        }
    }

    public static class Class
    extends TypeParamInfo {
        private final String typeName;
        private final Set<Variance> siteVariances;

        public Class(String typeName, int index, String name, Set<Variance> siteVariances) {
            super(index, name);
            this.typeName = typeName;
            this.siteVariances = siteVariances;
        }

        public boolean isSiteCovariant() {
            return this.siteVariances.size() == 1 && this.siteVariances.contains((Object)Variance.COVARIANT);
        }

        public boolean isSiteContravariant() {
            return this.siteVariances.size() == 1 && this.siteVariances.contains((Object)Variance.CONTRAVARIANT);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Class) {
                Class that = (Class)obj;
                return this.typeName.equals(that.typeName) && this.index == that.getIndex();
            }
            return false;
        }

        public String toString() {
            return "TypeParamInfo.Class[name=" + this.name + ",typeName=" + this.typeName + "]";
        }
    }
}

