/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn4j.impl;

import com.webauthn4j.async.WebAuthnAsyncManager;
import com.webauthn4j.async.anchor.KeyStoreTrustAnchorAsyncRepository;
import com.webauthn4j.async.anchor.TrustAnchorAsyncRepository;
import com.webauthn4j.async.metadata.FidoMDS3MetadataBLOBAsyncProvider;
import com.webauthn4j.async.metadata.HttpAsyncClient;
import com.webauthn4j.async.metadata.MetadataBLOBAsyncProvider;
import com.webauthn4j.async.metadata.anchor.MetadataBLOBBasedTrustAnchorAsyncRepository;
import com.webauthn4j.async.verifier.attestation.statement.androidkey.AndroidKeyAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.androidsafetynet.AndroidSafetyNetAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.apple.AppleAnonymousAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.none.NoneAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.packed.PackedAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.tpm.TPMAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.u2f.FIDOU2FAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.DefaultCertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.self.DefaultSelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.credential.CredentialRecord;
import com.webauthn4j.credential.CredentialRecordImpl;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.PublicKeyCredentialParameters;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.AndroidKeyAttestationStatement;
import com.webauthn4j.data.attestation.statement.AndroidSafetyNetAttestationStatement;
import com.webauthn4j.data.attestation.statement.AppleAnonymousAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.data.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.data.attestation.statement.PackedAttestationStatement;
import com.webauthn4j.data.attestation.statement.TPMAttestationStatement;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.server.ServerProperty;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.auth.webauthn4j.Attestation;
import io.vertx.ext.auth.webauthn4j.AttestationCertificates;
import io.vertx.ext.auth.webauthn4j.Authenticator;
import io.vertx.ext.auth.webauthn4j.AuthenticatorTransport;
import io.vertx.ext.auth.webauthn4j.CredentialStorage;
import io.vertx.ext.auth.webauthn4j.PublicKeyCredential;
import io.vertx.ext.auth.webauthn4j.ResidentKey;
import io.vertx.ext.auth.webauthn4j.UserVerification;
import io.vertx.ext.auth.webauthn4j.WebAuthn4J;
import io.vertx.ext.auth.webauthn4j.WebAuthn4JCredentials;
import io.vertx.ext.auth.webauthn4j.WebAuthn4JException;
import io.vertx.ext.auth.webauthn4j.WebAuthn4JOptions;
import io.vertx.ext.auth.webauthn4j.impl.VertxHttpAsyncClient;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class WebAuthn4JImpl
implements WebAuthn4J {
    private static final Logger LOG = LoggerFactory.getLogger(WebAuthn4J.class);
    private final VertxContextPRNG random;
    private final WebAuthn4JOptions options;
    private CredentialStorage credentialStorage;
    private final WebAuthnAsyncManager webAuthnManager;
    private final ObjectConverter objectConverter = new ObjectConverter();

    public WebAuthn4JImpl(Vertx vertx, WebAuthn4JOptions options) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.options = options;
        if (options == null) {
            throw new IllegalArgumentException("options cannot be null!");
        }
        if (options.getRelyingParty() == null) {
            throw new IllegalArgumentException("options.relyingParty cannot be null!");
        }
        if (options.getRelyingParty().getName() == null) {
            throw new IllegalArgumentException("options.relyingParty.name cannot be null!");
        }
        if (options.getAttestation() != Attestation.NONE) {
            KeyStoreTrustAnchorAsyncRepository something;
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                for (Map.Entry<String, X509Certificate> entry : options.getRootCertificates().entrySet()) {
                    CertificateHelper.CertInfo info = CertificateHelper.getCertInfo((X509Certificate)entry.getValue());
                    keyStore.setCertificateEntry(info.subject("CN"), entry.getValue());
                    trustAnchors.add(new TrustAnchor(entry.getValue(), null));
                }
                something = new KeyStoreTrustAnchorAsyncRepository(keyStore);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException(e);
            }
            if (options.isUseMetadata()) {
                VertxHttpAsyncClient httpClient = new VertxHttpAsyncClient(vertx);
                FidoMDS3MetadataBLOBAsyncProvider blobAsyncProvider = new FidoMDS3MetadataBLOBAsyncProvider(this.objectConverter, "https://mds.fidoalliance.org/", (HttpAsyncClient)httpClient, trustAnchors);
                something = new MetadataBLOBBasedTrustAnchorAsyncRepository(new MetadataBLOBAsyncProvider[]{blobAsyncProvider});
            }
            this.webAuthnManager = new WebAuthnAsyncManager(Arrays.asList(new NoneAttestationStatementAsyncVerifier(), new FIDOU2FAttestationStatementAsyncVerifier(), new PackedAttestationStatementAsyncVerifier(), new TPMAttestationStatementAsyncVerifier(), new AndroidKeyAttestationStatementAsyncVerifier(), new AndroidSafetyNetAttestationStatementAsyncVerifier(), new AppleAnonymousAttestationStatementAsyncVerifier()), (CertPathTrustworthinessAsyncVerifier)new DefaultCertPathTrustworthinessAsyncVerifier((TrustAnchorAsyncRepository)something), (SelfAttestationTrustworthinessAsyncVerifier)new DefaultSelfAttestationTrustworthinessAsyncVerifier(), this.objectConverter);
        } else {
            this.webAuthnManager = WebAuthnAsyncManager.createNonStrictWebAuthnAsyncManager((ObjectConverter)this.objectConverter);
        }
    }

    private String randomBase64URLBuffer(int length) {
        byte[] buff = new byte[length];
        this.random.nextBytes(buff);
        return Codec.base64UrlEncode((byte[])buff);
    }

    private void putOpt(JsonObject json, String key, Object value) {
        if (value != null) {
            if (value instanceof Enum) {
                json.put(key, (Object)value.toString());
                return;
            }
            if (value instanceof JsonObject && ((JsonObject)value).isEmpty()) {
                return;
            }
            if (value instanceof JsonArray && ((JsonArray)value).isEmpty()) {
                return;
            }
            json.put(key, value);
        }
    }

    private void addOpt(JsonArray json, Object value) {
        if (value != null) {
            if (value instanceof Enum) {
                json.add((Object)value.toString());
                return;
            }
            if (value instanceof JsonObject && ((JsonObject)value).isEmpty()) {
                return;
            }
            if (value instanceof JsonArray && ((JsonArray)value).isEmpty()) {
                return;
            }
            json.add(value);
        }
    }

    private static String uUIDtoBase64Url(UUID uuid) {
        Buffer buffer = Buffer.buffer((int)16);
        buffer.setLong(0, uuid.getMostSignificantBits());
        buffer.setLong(8, uuid.getLeastSignificantBits());
        return Codec.base64UrlEncode((byte[])buffer.getBytes());
    }

    @Override
    public WebAuthn4J credentialStorage(CredentialStorage credentialStorage) {
        if (credentialStorage == null) {
            throw new IllegalArgumentException("CredentialStorage cannot be null");
        }
        this.credentialStorage = credentialStorage;
        return this;
    }

    @Override
    public Future<JsonObject> createCredentialsOptions(JsonObject user) {
        return this.credentialStorage.find(user.getString("name"), null).map(authenticators -> {
            JsonObject json = new JsonObject().put("rp", (Object)new JsonObject()).put("user", (Object)new JsonObject()).put("challenge", (Object)this.randomBase64URLBuffer(this.options.getChallengeLength())).put("pubKeyCredParams", (Object)new JsonArray()).put("authenticatorSelection", (Object)new JsonObject());
            this.putOpt(json.getJsonObject("rp"), "id", this.options.getRelyingParty().getId());
            this.putOpt(json.getJsonObject("rp"), "name", this.options.getRelyingParty().getName());
            this.putOpt(json.getJsonObject("user"), "id", WebAuthn4JImpl.uUIDtoBase64Url(UUID.randomUUID()));
            this.putOpt(json.getJsonObject("user"), "name", user.getString("name"));
            this.putOpt(json.getJsonObject("user"), "displayName", user.getString("displayName"));
            this.putOpt(json.getJsonObject("user"), "icon", user.getString("icon"));
            for (PublicKeyCredential publicKeyCredential : this.options.getPubKeyCredParams()) {
                this.addOpt(json.getJsonArray("pubKeyCredParams"), new JsonObject().put("alg", (Object)publicKeyCredential.coseId()).put("type", (Object)"public-key"));
            }
            this.putOpt(json, "timeout", this.options.getTimeoutInMilliseconds());
            if (!authenticators.isEmpty()) {
                JsonArray transports = new JsonArray();
                for (AuthenticatorTransport transport : this.options.getTransports()) {
                    this.addOpt(transports, transport.toString());
                }
                JsonArray jsonArray = new JsonArray();
                for (Authenticator key : authenticators) {
                    JsonObject credentialDescriptor = new JsonObject().put("type", (Object)key.getType()).put("id", (Object)key.getCredID());
                    this.putOpt(credentialDescriptor, "transports", transports);
                    this.addOpt(jsonArray, credentialDescriptor);
                }
                this.putOpt(json, "excludeCredentials", jsonArray);
            }
            this.putOpt(json.getJsonObject("authenticatorSelection"), "authenticatorAttachment", (Object)this.options.getAuthenticatorAttachment());
            this.putOpt(json.getJsonObject("authenticatorSelection"), "residentKey", (Object)this.options.getResidentKey());
            this.putOpt(json.getJsonObject("authenticatorSelection"), "requireResidentKey", this.options.getResidentKey() == ResidentKey.REQUIRED);
            this.putOpt(json.getJsonObject("authenticatorSelection"), "userVerification", (Object)this.options.getUserVerification());
            this.putOpt(json, "attestation", (Object)this.options.getAttestation());
            this.putOpt(json, "extensions", this.options.getExtensions());
            return json;
        });
    }

    @Override
    public Future<JsonObject> getCredentialsOptions(String name) {
        JsonObject json = new JsonObject().put("challenge", (Object)this.randomBase64URLBuffer(this.options.getChallengeLength()));
        this.putOpt(json, "timeout", this.options.getTimeoutInMilliseconds());
        this.putOpt(json, "rpId", this.options.getRelyingParty().getId());
        this.putOpt(json, "userVerification", (Object)this.options.getUserVerification());
        this.putOpt(json, "extensions", this.options.getExtensions());
        switch (this.options.getResidentKey()) {
            case REQUIRED: 
            case PREFERRED: {
                return Future.succeededFuture((Object)json);
            }
            case DISCOURAGED: {
                if (name != null) break;
                return Future.failedFuture((String)"Name is required for non RK requests");
            }
        }
        return this.credentialStorage.find(name, null).compose(authenticators -> {
            if (authenticators.isEmpty()) {
                return Future.failedFuture((String)("No authenticators registered for user: " + name));
            }
            return Future.succeededFuture((Object)authenticators);
        }).map(authenticators -> {
            JsonArray allowCredentials = new JsonArray();
            JsonArray transports = new JsonArray();
            if (this.options.getTransports() != null) {
                for (AuthenticatorTransport transport : this.options.getTransports()) {
                    transports.add((Object)transport.toString());
                }
            }
            for (Authenticator key : authenticators) {
                String credId = key.getCredID();
                if (credId == null) continue;
                JsonObject credential = new JsonObject().put("type", (Object)"public-key").put("id", (Object)credId);
                this.putOpt(credential, "transports", transports);
                allowCredentials.add((Object)credential);
            }
            this.putOpt(json, "allowCredentials", allowCredentials);
            return json;
        });
    }

    public Future<User> authenticate(Credentials credentials) {
        try {
            WebAuthn4JCredentials authInfo;
            try {
                authInfo = (WebAuthn4JCredentials)credentials;
            }
            catch (ClassCastException e) {
                throw new CredentialValidationException("Invalid credentials type", (Throwable)e);
            }
            authInfo.checkValid(null);
            JsonObject webauthn = authInfo.getWebauthn();
            JsonObject response = webauthn.getJsonObject("response");
            byte[] clientDataJSON = Codec.base64UrlDecode((String)response.getString("clientDataJSON"));
            JsonObject clientData = new JsonObject(Buffer.buffer((byte[])clientDataJSON));
            if (!authInfo.getChallenge().equals(clientData.getString("challenge"))) {
                return Future.failedFuture((String)"Challenges don't match!");
            }
            if (authInfo.getOrigin() != null && !authInfo.getOrigin().equals(clientData.getString("origin"))) {
                return Future.failedFuture((String)("Origins don't match!" + clientData.getString("origin")));
            }
            String username = authInfo.getUsername();
            if (!clientData.containsKey("type")) {
                return Future.failedFuture((String)"Missing type on client data");
            }
            switch (clientData.getString("type")) {
                case "webauthn.create": {
                    if (username == null) {
                        return Future.failedFuture((String)"username can't be null!");
                    }
                    return this.verifyWebAuthNCreate(response, authInfo, clientDataJSON).compose(authrInfo -> {
                        authrInfo.setUserName(username);
                        return this.credentialStorage.storeCredential((Authenticator)authrInfo).compose(stored -> {
                            User user = User.create((JsonObject)authrInfo.toJson());
                            if ((authrInfo.getFlags() & 1) != 0) {
                                user.principal().put("amr", Arrays.asList("user", "swk"));
                            } else {
                                user.principal().put("amr", Collections.singletonList("swk"));
                            }
                            return Future.succeededFuture((Object)user);
                        });
                    });
                }
                case "webauthn.get": {
                    if (this.options.getResidentKey() == ResidentKey.DISCOURAGED && username == null) {
                        return Future.failedFuture((String)"username can't be null!");
                    }
                    String credentialId = webauthn.getString("id");
                    return this.credentialStorage.find(username, credentialId).compose(authenticators -> {
                        Objects.requireNonNull(authenticators);
                        if (authenticators.isEmpty()) {
                            return Future.failedFuture((String)("Cannot find authenticator with id: " + webauthn.getString("id")));
                        }
                        if (authenticators.size() == 1) {
                            Authenticator authenticator = (Authenticator)authenticators.get(0);
                            return this.verifyWebAuthNGet(response, authInfo, clientDataJSON, authenticator).compose(counter -> {
                                authenticator.setCounter((long)counter);
                                return this.credentialStorage.updateCounter(authenticator).compose(stored -> {
                                    User user = User.create((JsonObject)authenticator.toJson());
                                    if ((authenticator.getFlags() & 1) != 0) {
                                        user.principal().put("amr", Arrays.asList("user", "swk"));
                                    } else {
                                        user.principal().put("amr", Collections.singletonList("swk"));
                                    }
                                    return Future.succeededFuture((Object)user);
                                });
                            });
                        }
                        return Future.failedFuture((String)("Found multiple authenticators for id: " + webauthn.getString("id") + " and username: " + username + " which breaks the contract of CredentialStorage"));
                    });
                }
            }
            return Future.failedFuture((String)"Can not determine type of response!");
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    private Future<Authenticator> verifyWebAuthNCreate(JsonObject response, WebAuthn4JCredentials authInfo, byte[] clientDataJSON) {
        JsonObject clientExtensionResults;
        byte[] attestationObject = Codec.base64UrlDecode((String)response.getString("attestationObject"));
        HashSet<String> transports = new HashSet<String>();
        JsonArray transportsArray = response.getJsonArray("transports");
        if (transportsArray != null) {
            for (Object object : transportsArray) {
                if (object instanceof String) {
                    transports.add((String)object);
                    continue;
                }
                return Future.failedFuture((Throwable)new WebAuthn4JException("Invalid transport: " + object));
            }
        }
        String clientExtensionJSON = (clientExtensionResults = response.getJsonObject("clientExtensionResults")) != null ? clientExtensionResults.encode() : null;
        RegistrationRequest registrationRequest = new RegistrationRequest(attestationObject, clientDataJSON, clientExtensionJSON, transports);
        ServerProperty serverProperty = this.getServerProperty(authInfo);
        boolean userVerificationRequired = this.options.getUserVerification() == UserVerification.REQUIRED;
        boolean userPresenceRequired = this.options.isUserPresenceRequired();
        ArrayList<PublicKeyCredentialParameters> pubKeyCredParams = new ArrayList<PublicKeyCredentialParameters>(this.options.getPubKeyCredParams().size());
        for (PublicKeyCredential publicKeyCredential : this.options.getPubKeyCredParams()) {
            pubKeyCredParams.add(new PublicKeyCredentialParameters(PublicKeyCredentialType.PUBLIC_KEY, COSEAlgorithmIdentifier.create((long)publicKeyCredential.coseId())));
        }
        RegistrationParameters registrationParameters = new RegistrationParameters(serverProperty, pubKeyCredParams, userVerificationRequired, userPresenceRequired);
        return Future.fromCompletionStage((CompletionStage)this.webAuthnManager.verify(registrationRequest, registrationParameters)).map(registrationData -> {
            AttestationCertificates attestationCertificates = this.convertAttestationCertificates(registrationData.getAttestationObject().getAttestationStatement());
            COSEKey coseKey = registrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getCOSEKey();
            return new Authenticator().setFmt(registrationData.getAttestationObject().getAttestationStatement().getFormat()).setAaguid(registrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getAaguid().toString()).setPublicKey(Codec.base64UrlEncode((byte[])this.objectConverter.getCborConverter().writeValueAsBytes((Object)coseKey))).setCounter(registrationData.getAttestationObject().getAuthenticatorData().getSignCount()).setCredID(Codec.base64UrlEncode((byte[])registrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getCredentialId())).setAttestationCertificates(attestationCertificates).setFlags(registrationData.getAttestationObject().getAuthenticatorData().getFlags());
        });
    }

    private AttestationCertificates convertAttestationCertificates(AttestationStatement attestationStatement) {
        AttestationCertificates attestationCertificates = new AttestationCertificates();
        if (attestationStatement instanceof CertificateBaseAttestationStatement) {
            AttestationCertificatePath x5c = ((CertificateBaseAttestationStatement)attestationStatement).getX5c();
            if (x5c != null) {
                attestationCertificates.setX5c(x5c.stream().map(cert -> {
                    try {
                        return Codec.base64UrlEncode((byte[])cert.getEncoded());
                    }
                    catch (CertificateEncodingException e) {
                        throw new WebAuthn4JException(e);
                    }
                }).collect(Collectors.toList()));
            }
            if (attestationStatement instanceof AndroidKeyAttestationStatement) {
                attestationCertificates.setAlg(PublicKeyCredential.valueOf((int)((AndroidKeyAttestationStatement)attestationStatement).getAlg().getValue()));
            } else if (attestationStatement instanceof AndroidSafetyNetAttestationStatement) {
                attestationCertificates.setAlg(PublicKeyCredential.valueOf(((AndroidSafetyNetAttestationStatement)attestationStatement).getResponse().getHeader().getAlg().getName()));
            } else if (attestationStatement instanceof AppleAnonymousAttestationStatement) {
                attestationCertificates.setAlg(null);
            } else if (attestationStatement instanceof FIDOU2FAttestationStatement) {
                attestationCertificates.setAlg(PublicKeyCredential.valueOf((int)COSEAlgorithmIdentifier.ES256.getValue()));
            } else if (attestationStatement instanceof PackedAttestationStatement) {
                attestationCertificates.setAlg(PublicKeyCredential.valueOf((int)((PackedAttestationStatement)attestationStatement).getAlg().getValue()));
            } else if (attestationStatement instanceof TPMAttestationStatement) {
                attestationCertificates.setAlg(PublicKeyCredential.valueOf((int)((TPMAttestationStatement)attestationStatement).getAlg().getValue()));
            } else {
                throw new WebAuthn4JException("Unsupported attestation statement format: " + attestationStatement.getFormat());
            }
        }
        return attestationCertificates;
    }

    private ServerProperty getServerProperty(WebAuthn4JCredentials authInfo) {
        Origin origin = Origin.create((String)authInfo.getOrigin());
        String rpId = this.options.getRelyingParty().getId();
        if (rpId == null) {
            rpId = origin.getHost();
        }
        DefaultChallenge challenge = new DefaultChallenge(authInfo.getChallenge());
        byte[] tokenBindingId = null;
        return new ServerProperty(origin, rpId, (Challenge)challenge, tokenBindingId);
    }

    private Future<Long> verifyWebAuthNGet(JsonObject response, WebAuthn4JCredentials request, byte[] clientDataJSON, Authenticator authenticator) {
        byte[] credentialId = Codec.base64UrlDecode((String)request.getWebauthn().getString("id"));
        byte[] userHandle = response.containsKey("userHandle") ? Codec.base64UrlDecode((String)response.getString("userHandle")) : null;
        byte[] authenticatorData = Codec.base64UrlDecode((String)response.getString("authenticatorData"));
        JsonObject clientExtensionResults = response.getJsonObject("clientExtensionResults");
        String clientExtensionJSON = clientExtensionResults != null ? clientExtensionResults.encode() : null;
        byte[] signature = Codec.base64UrlDecode((String)response.getString("signature"));
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(credentialId, userHandle, authenticatorData, clientDataJSON, clientExtensionJSON, signature);
        ServerProperty serverProperty = this.getServerProperty(request);
        List<byte[]> allowCredentials = List.of(Codec.base64UrlDecode((String)authenticator.getCredID()));
        boolean userVerificationRequired = this.options.getUserVerification() == UserVerification.REQUIRED;
        boolean userPresenceRequired = this.options.isUserPresenceRequired();
        CredentialRecord credentialRecord = this.loadCredentialRecord(authenticator);
        AuthenticationParameters authenticationParameters = new AuthenticationParameters(serverProperty, (com.webauthn4j.authenticator.Authenticator)credentialRecord, allowCredentials, userVerificationRequired, userPresenceRequired);
        return Future.fromCompletionStage((CompletionStage)this.webAuthnManager.verify(authenticationRequest, authenticationParameters)).map(parsedAuthenticatorData -> parsedAuthenticatorData.getAuthenticatorData().getSignCount());
    }

    private CredentialRecord loadCredentialRecord(Authenticator authenticator) {
        long counter = authenticator.getCounter();
        COSEKey coseKey = (COSEKey)this.objectConverter.getCborConverter().readValue(Codec.base64UrlDecode((String)authenticator.getPublicKey()), COSEKey.class);
        byte[] credentialId = Codec.base64UrlDecode((String)authenticator.getCredID());
        AAGUID aaguid = new AAGUID(authenticator.getAaguid());
        AttestedCredentialData attestedCredentialData = new AttestedCredentialData(aaguid, credentialId, coseKey);
        AttestationStatement attestationStatement = null;
        Boolean uvInitialized = null;
        Boolean backupEligible = null;
        Boolean backupState = null;
        AuthenticationExtensionsAuthenticatorOutputs authenticatorExtensions = null;
        CollectedClientData clientData = null;
        AuthenticationExtensionsClientOutputs clientExtensions = null;
        Set transports = null;
        return new CredentialRecordImpl(attestationStatement, uvInitialized, backupEligible, backupState, counter, attestedCredentialData, authenticatorExtensions, clientData, clientExtensions, transports);
    }
}

