/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn4j;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.impl.jose.JWS;
import io.vertx.ext.auth.webauthn4j.Attestation;
import io.vertx.ext.auth.webauthn4j.AuthenticatorAttachment;
import io.vertx.ext.auth.webauthn4j.AuthenticatorTransport;
import io.vertx.ext.auth.webauthn4j.PublicKeyCredential;
import io.vertx.ext.auth.webauthn4j.RelyingParty;
import io.vertx.ext.auth.webauthn4j.ResidentKey;
import io.vertx.ext.auth.webauthn4j.UserVerification;
import io.vertx.ext.auth.webauthn4j.WebAuthn4JOptionsConverter;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class WebAuthn4JOptions {
    private static final Logger LOG = LoggerFactory.getLogger(WebAuthn4JOptions.class);
    private static final String ANDROID_KEYSTORE_ROOT = "MIICizCCAjKgAwIBAgIJAKIFntEOQ1tXMAoGCCqGSM49BAMCMIGYMQswCQYDVQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEWMBQGA1UEBwwNTW91bnRhaW4gVmlldzEVMBMGA1UECgwMR29vZ2xlLCBJbmMuMRAwDgYDVQQLDAdBbmRyb2lkMTMwMQYDVQQDDCpBbmRyb2lkIEtleXN0b3JlIFNvZnR3YXJlIEF0dGVzdGF0aW9uIFJvb3QwHhcNMTYwMTExMDA0MzUwWhcNMzYwMTA2MDA0MzUwWjCBmDELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDU1vdW50YWluIFZpZXcxFTATBgNVBAoMDEdvb2dsZSwgSW5jLjEQMA4GA1UECwwHQW5kcm9pZDEzMDEGA1UEAwwqQW5kcm9pZCBLZXlzdG9yZSBTb2Z0d2FyZSBBdHRlc3RhdGlvbiBSb290MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE7l1ex+HA220Dpn7mthvsTWpdamguD/9/SQ59dx9EIm29sa/6FsvHrcV30lacqrewLVQBXT5DKyqO107sSHVBpKNjMGEwHQYDVR0OBBYEFMit6XdMRcOjzw0WEOR5QzohWjDPMB8GA1UdIwQYMBaAFMit6XdMRcOjzw0WEOR5QzohWjDPMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgKEMAoGCCqGSM49BAMCA0cAMEQCIDUho++LNEYenNVg8x1YiSBq3KNlQfYNns6KGYxmSGB7AiBNC/NR2TB8fVvaNTQdqEcbY6WFZTytTySn502vQX3xvw==";
    private static final String GSR1 = "MIIDdTCCAl2gAwIBAgILBAAAAAABFUtaw5QwDQYJKoZIhvcNAQEFBQAwVzELMAkG\nA1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv\nb3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MDExMjAw\nMDBaFw0yODAxMjgxMjAwMDBaMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i\nYWxTaWduIG52LXNhMRAwDgYDVQQLEwdSb290IENBMRswGQYDVQQDExJHbG9iYWxT\naWduIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDaDuaZ\njc6j40+Kfvvxi4Mla+pIH/EqsLmVEQS98GPR4mdmzxzdzxtIK+6NiY6arymAZavp\nxy0Sy6scTHAHoT0KMM0VjU/43dSMUBUc71DuxC73/OlS8pF94G3VNTCOXkNz8kHp\n1Wrjsok6Vjk4bwY8iGlbKk3Fp1S4bInMm/k8yuX9ifUSPJJ4ltbcdG6TRGHRjcdG\nsnUOhugZitVtbNV4FpWi6cgKOOvyJBNPc1STE4U6G7weNLWLBYy5d4ux2x8gkasJ\nU26Qzns3dLlwR5EiUWMWea6xrkEmCMgZK9FGqkjWZCrXgzT/LCrBbBlDSgeF59N8\n9iFo7+ryUp9/k5DPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8E\nBTADAQH/MB0GA1UdDgQWBBRge2YaRQ2XyolQL30EzTSo//z9SzANBgkqhkiG9w0B\nAQUFAAOCAQEA1nPnfE920I2/7LqivjTFKDK1fPxsnCwrvQmeU79rXqoRSLblCKOz\nyj1hTdNGCbM+w6DjY1Ub8rrvrTnhQ7k4o+YviiY776BQVvnGCv04zcQLcFGUl5gE\n38NflNUVyRRBnMRddWQVDf9VMOyGj/8N7yy5Y0b2qvzfvGn9LhJIZJrglfCm7ymP\nAbEVtQwdpf5pLGkkeB6zpxxxYu7KyJesF12KwvhHhm4qxFYxldBniYUr+WymXUad\nDKqC5JlR3XC321Y9YeRq4VzW9v493kHMB65jUr9TU/Qr6cf9tveCX4XSQRjbgbME\nHMUfpIBvFSDJ3gyICh3WZlXi/EjJKSZp4A==";
    @Deprecated
    private static final String GSR2 = "MIIDvDCCAqSgAwIBAgINAgPk9GHsmdnVeWbKejANBgkqhkiG9w0BAQUFADBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMjETMBEGA1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjAeFw0wNjEyMTUwODAwMDBaFw0yMTEyMTUwODAwMDBaMEwxIDAeBgNVBAsTF0dsb2JhbFNpZ24gUm9vdCBDQSAtIFIyMRMwEQYDVQQKEwpHbG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWduMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAps8kDr4ubyiZRULEqz4hVJsL03+EcPoSs8u/h1/Gf4bTsjBc1v2t8Xvc5fhglgmSEPXQU977e35ziKxSiHtKpspJpl6op4xaEbx6guu+jOmzrJYlB5dKmSoHL7Qed7+KD7UCfBuWuMW5Oiy81hK561l94tAGhl9eSWq1OV6INOy8eAwImIRsqM1LtKB9DHlN8LgtyyHK1WxbfeGgKYSh+dOUScskYpEgvN0L1dnM+eonCitzkcadG6zIy+jgoPQvkItN+7A2G/YZeoXgbfJhE4hcn+CTClGXilrOr6vV96oJqmC93Nlf33KpYBNeAAHJSvo/pOoHAyECjoLKA8KbjwIDAQABo4GcMIGZMA4GA1UdDwEB/wQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBSb4gdXZxwewGoG3lm0mi3f3BmGLjAfBgNVHSMEGDAWgBSb4gdXZxwewGoG3lm0mi3f3BmGLjA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vY3JsLmdsb2JhbHNpZ24ubmV0L3Jvb3QtcjIuY3JsMA0GCSqGSIb3DQEBBQUAA4IBAQANeX81Z1YqDIs4EaLjG0qPOxIzaJI/y4kiRj3a+y3KOx74clIkLuMgi/9/5iv/n+1LyhGU9g7174slbzJOPbSpp1eT19ST2mYbdgTLx/hm3tTLoHIY/w4ZbnQYwfnPwAG4RefnEFYPQJmpD+Wh8BJwBgtm2drTale/T6NBwmwnEFunfaMfMX3g6IBrx7VKnxIkJh/3p190WveLKgl9n7i5SWce/4woPimEn9WfEQWRvp6wKhaCKFjuCMuulEZusoOUJ4LfJnXxcuQTgIrSnwI7KfSSjsd42w3lX1fbgJp7vPmLM6OBRvAXuYRKTFqMAWbb7OaGIEE+cbxY6PDepnva";
    private static final String APPLE_WEBAUTHN_ROOT_CA = "MIICEjCCAZmgAwIBAgIQaB0BbHo84wIlpQGUKEdXcTAKBggqhkjOPQQDAzBLMR8wHQYDVQQDDBZBcHBsZSBXZWJBdXRobiBSb290IENBMRMwEQYDVQQKDApBcHBsZSBJbmMuMRMwEQYDVQQIDApDYWxpZm9ybmlhMB4XDTIwMDMxODE4MjEzMloXDTQ1MDMxNTAwMDAwMFowSzEfMB0GA1UEAwwWQXBwbGUgV2ViQXV0aG4gUm9vdCBDQTETMBEGA1UECgwKQXBwbGUgSW5jLjETMBEGA1UECAwKQ2FsaWZvcm5pYTB2MBAGByqGSM49AgEGBSuBBAAiA2IABCJCQ2pTVhzjl4Wo6IhHtMSAzO2cv+H9DQKev3//fG59G11kxu9eI0/7o6V5uShBpe1u6l6mS19S1FEh6yGljnZAJ+2GNP1mi/YK2kSXIuTHjxA/pcoRf7XkOtO4o1qlcaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUJtdk2cV4wlpn0afeaxLQG2PxxtcwDgYDVR0PAQH/BAQDAgEGMAoGCCqGSM49BAMDA2cAMGQCMFrZ+9DsJ1PW9hfNdBywZDsWDbWFp28it1d/5w2RPkRX3Bbn/UbDTNLx7Jr3jAGGiQIwHFj+dJZYUJR786osByBelJYsVZd2GbHQu209b5RCmGQ21gpSAk9QZW4B1bWeT0vT";
    @Deprecated
    private static final String FIDO_MDS_ROOT_CERTIFICATE = "MIICQzCCAcigAwIBAgIORqmxkzowRM99NQZJurcwCgYIKoZIzj0EAwMwUzELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUZJRE8gQWxsaWFuY2UxHTAbBgNVBAsTFE1ldGFkYXRhIFRPQyBTaWduaW5nMQ0wCwYDVQQDEwRSb290MB4XDTE1MDYxNzAwMDAwMFoXDTQ1MDYxNzAwMDAwMFowUzELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUZJRE8gQWxsaWFuY2UxHTAbBgNVBAsTFE1ldGFkYXRhIFRPQyBTaWduaW5nMQ0wCwYDVQQDEwRSb290MHYwEAYHKoZIzj0CAQYFK4EEACIDYgAEFEoo+6jdxg6oUuOloqPjK/nVGyY+AXCFz1i5JR4OPeFJs+my143ai0p34EX4R1Xxm9xGi9n8F+RxLjLNPHtlkB3X4imsrfIx7QcEImx1cMTgu5zUiwxLX1ookVhIRSoso2MwYTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU0qUfC6f2YshA1Ni9udeO0VS7vEYwHwYDVR0jBBgwFoAU0qUfC6f2YshA1Ni9udeO0VS7vEYwCgYIKoZIzj0EAwMDaQAwZgIxAKulGbSFkDSZusGjbNkAhAkqTkLWo3GrN5nRBNNk2Q4BlG+AvM5q9wa5WciWDcMdeQIxAMOEzOFsxX9Bo0h4LOFE5y5H8bdPFYW+l5gy1tQiJv+5NUyM2IBB55XUYjdBz56jSA==";
    private static final String FIDO_MDS3_ROOT_CERTIFICATE = "MIIDXzCCAkegAwIBAgILBAAAAAABIVhTCKIwDQYJKoZIhvcNAQELBQAwTDEgMB4GA1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoTCkdsb2JhbFNpZ24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDkwMzE4MTAwMDAwWhcNMjkwMzE4MTAwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEGA1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMwldpB5BngiFvXAg7aEyiie/QV2EcWtiHL8RgJDx7KKnQRfJMsuS+FggkbhUqsMgUdwbN1k0ev1LKMPgj0MK66X17YUhhB5uzsTgHeMCOFJ0mpiLx9e+pZo34knlTifBtc+ycsmWQ1z3rDI6SYOgxXG71uL0gRgykmmKPZpO/bLyCiR5Z2KYVc3rHQU3HTgOu5yLy6c+9C7v/U9AOEGM+iCK65TpjoWc4zdQQ4gOsC0p6Hpsk+QLjJg6VfLuQSSaGjlOCZgdbKfd/+RFO+uIEn8rUAVSNECMWEZXriX7613t2Saer9fwRPvm2L7DWzgVGkWqQPabumDk3F2xmmFghcCAwEAAaNCMEAwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFI/wS3+oLkUkrk1Q+mOai97i3Ru8MA0GCSqGSIb3DQEBCwUAA4IBAQBLQNvAUKr+yAzv95ZURUm7lgAJQayzE4aGKAczymvmdLm6AC2upArT9fHxD4q/c2dKg8dEe3jgr25sbwMpjjM5RcOO5LlXbKr8EpbsU8Yt5CRsuZRj+9xTaGdWPoO4zzUhw8lo/s7awlOqzJCK6fBdRoyV3XpYKBovHd7NADdBj+1EbddTKJd+82cEHhXXipa0095MJ6RMG3NzdvQXmcIfeg7jLQitChws/zyrVQ4PkX4268NXSb7hLi18YIvDQVETI53O9zJrlAGomecsMx86OyXShkDOOyyGeMlhLxS67ttVb9+E7gUJTb0o2HLO02JQZR7rkpeDMdmztcpHWD9f";
    private List<AuthenticatorTransport> transports;
    private RelyingParty relyingParty;
    private AuthenticatorAttachment authenticatorAttachment;
    private ResidentKey residentKey;
    private UserVerification userVerification;
    private Long timeout;
    private Attestation attestation;
    private List<PublicKeyCredential> pubKeyCredParams;
    private int challengeLength;
    private JsonObject extensions;
    private Map<String, X509Certificate> rootCertificates;
    private boolean relaxedSafetyNetIntegrityVeridict;
    private boolean useMetadata;
    private boolean userPresenceRequired;

    public WebAuthn4JOptions() {
        this.init();
    }

    public WebAuthn4JOptions(JsonObject json) {
        this();
        WebAuthn4JOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    private void init() {
        this.userVerification = UserVerification.DISCOURAGED;
        this.attestation = Attestation.NONE;
        this.residentKey = ResidentKey.DISCOURAGED;
        this.extensions = new JsonObject().put("txAuthSimple", (Object)"");
        this.timeout = 60000L;
        this.challengeLength = 64;
        this.addPubKeyCredParam(PublicKeyCredential.ES256);
        this.addPubKeyCredParam(PublicKeyCredential.RS256);
        this.addTransport(AuthenticatorTransport.USB);
        this.addTransport(AuthenticatorTransport.NFC);
        this.addTransport(AuthenticatorTransport.BLE);
        this.addTransport(AuthenticatorTransport.HYBRID);
        this.addTransport(AuthenticatorTransport.INTERNAL);
        try {
            this.putRootCertificate("android-key", ANDROID_KEYSTORE_ROOT);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)"Ignoring root certificate", (Throwable)e);
        }
        try {
            this.putRootCertificate("android-safetynet", GSR1);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)"Ignoring root certificate", (Throwable)e);
        }
        try {
            this.putRootCertificate("apple", APPLE_WEBAUTHN_ROOT_CA);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)"Ignoring root certificate", (Throwable)e);
        }
        try {
            this.putRootCertificate("mds", FIDO_MDS3_ROOT_CERTIFICATE);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)"Ignoring root certificate", (Throwable)e);
        }
    }

    public RelyingParty getRelyingParty() {
        return this.relyingParty;
    }

    public WebAuthn4JOptions setRelyingParty(RelyingParty relyingParty) {
        if (relyingParty.getName() == null) {
            throw new IllegalArgumentException("RelyingParty name cannot be null");
        }
        this.relyingParty = relyingParty;
        return this;
    }

    public List<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public WebAuthn4JOptions setTransports(List<AuthenticatorTransport> transports) {
        if (transports == null) {
            throw new IllegalArgumentException("transports cannot be null");
        }
        this.transports = transports;
        return this;
    }

    public WebAuthn4JOptions addTransport(AuthenticatorTransport transport) {
        if (transport == null) {
            throw new IllegalArgumentException("transport cannot be null");
        }
        if (this.transports == null) {
            this.transports = new ArrayList<AuthenticatorTransport>();
        }
        this.transports.add(transport);
        return this;
    }

    public Attestation getAttestation() {
        return this.attestation;
    }

    public WebAuthn4JOptions setAttestation(Attestation attestation) {
        if (this.userVerification == null) {
            throw new IllegalArgumentException("userVerification cannot be null");
        }
        this.attestation = attestation;
        return this;
    }

    public ResidentKey getResidentKey() {
        return this.residentKey;
    }

    public WebAuthn4JOptions setResidentKey(ResidentKey residentKey) {
        this.residentKey = residentKey;
        return this;
    }

    public List<PublicKeyCredential> getPubKeyCredParams() {
        return this.pubKeyCredParams;
    }

    public WebAuthn4JOptions addPubKeyCredParam(PublicKeyCredential pubKeyCredParam) {
        if (pubKeyCredParam == null) {
            throw new IllegalArgumentException("pubKeyCredParam cannot be null");
        }
        if (this.pubKeyCredParams == null) {
            this.pubKeyCredParams = new ArrayList<PublicKeyCredential>();
        }
        if (!this.pubKeyCredParams.contains((Object)pubKeyCredParam)) {
            this.pubKeyCredParams.add(pubKeyCredParam);
        }
        return this;
    }

    public WebAuthn4JOptions setPubKeyCredParams(List<PublicKeyCredential> pubKeyCredParams) {
        if (pubKeyCredParams.size() == 0) {
            throw new IllegalArgumentException("PubKeyCredParams must have at least 1 element");
        }
        this.pubKeyCredParams = pubKeyCredParams;
        return this;
    }

    public AuthenticatorAttachment getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    public WebAuthn4JOptions setAuthenticatorAttachment(AuthenticatorAttachment authenticatorAttachment) {
        this.authenticatorAttachment = authenticatorAttachment;
        return this;
    }

    public WebAuthn4JOptions setRequireResidentKey(Boolean requireResidentKey) {
        this.residentKey = requireResidentKey == null || requireResidentKey == false ? ResidentKey.DISCOURAGED : ResidentKey.REQUIRED;
        return this;
    }

    public UserVerification getUserVerification() {
        return this.userVerification;
    }

    public WebAuthn4JOptions setUserVerification(UserVerification userVerification) {
        if (userVerification == null) {
            throw new IllegalArgumentException("userVerification cannot be null");
        }
        this.userVerification = userVerification;
        return this;
    }

    public Long getTimeoutInMilliseconds() {
        return this.timeout;
    }

    public WebAuthn4JOptions setTimeoutInMilliseconds(Long timeoutInMilliseconds) {
        if (timeoutInMilliseconds != null && timeoutInMilliseconds < 0L) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        this.timeout = timeoutInMilliseconds;
        return this;
    }

    public int getChallengeLength() {
        return this.challengeLength;
    }

    public WebAuthn4JOptions setChallengeLength(int challengeLength) {
        if (challengeLength < 32) {
            throw new IllegalArgumentException("Challenge length must be >= 32");
        }
        this.challengeLength = challengeLength;
        return this;
    }

    public JsonObject getExtensions() {
        return this.extensions;
    }

    public WebAuthn4JOptions setExtensions(JsonObject extensions) {
        this.extensions = extensions;
        return this;
    }

    @GenIgnore(value={"permitted-type"})
    public Map<String, X509Certificate> getRootCertificates() {
        return this.rootCertificates;
    }

    public @Nullable X509Certificate getRootCertificate(String key) {
        if (this.rootCertificates == null) {
            return null;
        }
        return this.rootCertificates.get(key);
    }

    public WebAuthn4JOptions setRootCertificates(Map<String, String> rootCertificates) {
        if (rootCertificates == null) {
            this.rootCertificates = null;
        } else {
            for (Map.Entry<String, String> kv : rootCertificates.entrySet()) {
                this.putRootCertificate(kv.getKey(), kv.getValue());
            }
        }
        return this;
    }

    public WebAuthn4JOptions putRootCertificate(String key, String value) {
        try {
            X509Certificate cert = JWS.parseX5c((String)value);
            return this.putRootCertificate(key, cert);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Invalid root certificate", e);
        }
    }

    public WebAuthn4JOptions putRootCertificate(String key, X509Certificate cert) {
        if (this.rootCertificates == null) {
            this.rootCertificates = new HashMap<String, X509Certificate>();
        }
        try {
            cert.checkValidity();
            this.rootCertificates.put(key, cert);
            return this;
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Invalid root certificate", e);
        }
    }

    @GenIgnore
    public WebAuthn4JOptions addRootCertificate(X509Certificate rootCA) {
        CertificateHelper.CertInfo certInfo = CertificateHelper.getCertInfo((X509Certificate)rootCA);
        String name = certInfo.subject("CN");
        if (name == null) {
            throw new IllegalArgumentException("Root certificate has no 'CN' subject");
        }
        return this.putRootCertificate(name, rootCA);
    }

    public boolean isRelaxedSafetyNetIntegrityVeridict() {
        return this.relaxedSafetyNetIntegrityVeridict;
    }

    public WebAuthn4JOptions setRelaxedSafetyNetIntegrityVeridict(boolean relaxedSafetyNetIntegrityVeridict) {
        this.relaxedSafetyNetIntegrityVeridict = relaxedSafetyNetIntegrityVeridict;
        return this;
    }

    public WebAuthn4JOptions setUseMetadata(boolean useMetadata) {
        this.useMetadata = useMetadata;
        return this;
    }

    public boolean isUseMetadata() {
        return this.useMetadata;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        WebAuthn4JOptionsConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return this.toJson().encodePrettily();
    }

    public boolean isUserPresenceRequired() {
        return this.userPresenceRequired;
    }

    public WebAuthn4JOptions setUserPresenceRequired(boolean userPresenceRequired) {
        this.userPresenceRequired = userPresenceRequired;
        return this;
    }
}

