/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn4j;

import io.vertx.codegen.annotations.VertxGen;

@VertxGen
public enum PublicKeyCredential {
    ES256(-7),
    ES384(-35),
    ES512(-36),
    PS256(-37),
    PS384(-38),
    PS512(-39),
    ES256K(-47),
    RS256(-257),
    RS384(-258),
    RS512(-259),
    RS1(-65535),
    EdDSA(-8);

    private final int coseId;

    private PublicKeyCredential(int coseId) {
        this.coseId = coseId;
    }

    public static PublicKeyCredential valueOf(int coseId) {
        switch (coseId) {
            case -7: {
                return ES256;
            }
            case -35: {
                return ES384;
            }
            case -36: {
                return ES512;
            }
            case -37: {
                return PS256;
            }
            case -38: {
                return PS384;
            }
            case -39: {
                return PS512;
            }
            case -47: {
                return ES256K;
            }
            case -257: {
                return RS256;
            }
            case -258: {
                return RS384;
            }
            case -259: {
                return RS512;
            }
            case -65535: {
                return RS1;
            }
            case -8: {
                return EdDSA;
            }
        }
        throw new IllegalArgumentException("Unknown cose-id: " + coseId);
    }

    public int coseId() {
        return this.coseId;
    }
}

