/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn4j;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.webauthn4j.AttestationCertificates;
import io.vertx.ext.auth.webauthn4j.Authenticator;
import java.util.Map;

public class AuthenticatorConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, Authenticator obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "userName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUserName((String)member.getValue());
                    break;
                }
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setType((String)member.getValue());
                    break;
                }
                case "credID": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCredID((String)member.getValue());
                    break;
                }
                case "publicKey": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPublicKey((String)member.getValue());
                    break;
                }
                case "counter": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCounter(((Number)member.getValue()).longValue());
                    break;
                }
                case "attestationCertificates": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setAttestationCertificates(new AttestationCertificates((JsonObject)member.getValue()));
                    break;
                }
                case "flags": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setFlags(((Number)member.getValue()).intValue());
                    break;
                }
                case "fmt": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setFmt((String)member.getValue());
                    break;
                }
                case "aaguid": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAaguid((String)member.getValue());
                }
            }
        }
    }

    static void toJson(Authenticator obj, JsonObject json) {
        AuthenticatorConverter.toJson(obj, json.getMap());
    }

    static void toJson(Authenticator obj, Map<String, Object> json) {
        if (obj.getUserName() != null) {
            json.put("userName", obj.getUserName());
        }
        if (obj.getType() != null) {
            json.put("type", obj.getType());
        }
        if (obj.getCredID() != null) {
            json.put("credID", obj.getCredID());
        }
        if (obj.getPublicKey() != null) {
            json.put("publicKey", obj.getPublicKey());
        }
        json.put("counter", obj.getCounter());
        if (obj.getAttestationCertificates() != null) {
            json.put("attestationCertificates", obj.getAttestationCertificates().toJson());
        }
        json.put("flags", obj.getFlags());
        if (obj.getFmt() != null) {
            json.put("fmt", obj.getFmt());
        }
        if (obj.getAaguid() != null) {
            json.put("aaguid", obj.getAaguid());
        }
    }
}

