/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.sqlclient.impl;

import io.vertx.core.Future;
import io.vertx.ext.auth.hashing.HashingStrategy;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.sqlclient.SqlUserUtil;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.Tuple;
import java.security.SecureRandom;

public class SqlUserUtilImpl
implements SqlUserUtil {
    private static final String INSERT_USER = "INSERT INTO user (username, password) VALUES (?, ?)";
    private static final String INSERT_USER_ROLE = "INSERT INTO user_roles (username, role) VALUES (?, ?)";
    private static final String INSERT_ROLE_PERMISSION = "INSERT INTO roles_perms (role, permission) VALUES (?, ?)";
    private final SqlClient client;
    private final HashingStrategy strategy = HashingStrategy.load();
    private final SecureRandom random = new SecureRandom();
    private final String insertUser;
    private final String insertUserRole;
    private final String insertRolePermission;

    public SqlUserUtilImpl(SqlClient client) {
        this(client, INSERT_USER, INSERT_USER_ROLE, INSERT_ROLE_PERMISSION);
    }

    public SqlUserUtilImpl(SqlClient client, String insertUser, String insertUserRole, String insertRolePermission) {
        this.client = client;
        this.insertUser = insertUser;
        this.insertUserRole = insertUserRole;
        this.insertRolePermission = insertRolePermission;
    }

    @Override
    public Future<Void> createUser(String username, String password) {
        if (username == null || password == null) {
            return Future.failedFuture((String)"username or password are null");
        }
        byte[] salt = new byte[32];
        this.random.nextBytes(salt);
        return this.createHashedUser(username, this.strategy.hash("pbkdf2", null, Codec.base64Encode((byte[])salt), password));
    }

    @Override
    public Future<Void> createHashedUser(String username, String hash) {
        if (username == null || hash == null) {
            return Future.failedFuture((String)"username or password hash are null");
        }
        return this.client.preparedQuery(this.insertUser).execute(Tuple.of((Object)username, (Object)hash)).mapEmpty();
    }

    @Override
    public Future<Void> createUserRole(String username, String role) {
        if (username == null || role == null) {
            return Future.failedFuture((String)"username or role are null");
        }
        return this.client.preparedQuery(this.insertUserRole).execute(Tuple.of((Object)username, (Object)role)).mapEmpty();
    }

    @Override
    public Future<Void> createRolePermission(String role, String permission) {
        if (role == null || permission == null) {
            return Future.failedFuture((String)"role or permission are null");
        }
        return this.client.preparedQuery(this.insertRolePermission).execute(Tuple.of((Object)role, (Object)permission)).mapEmpty();
    }
}

