/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.HashingStrategy;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.sqlclient.SqlAuthentication;
import io.vertx.ext.auth.sqlclient.SqlAuthenticationOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.Tuple;
import java.util.Map;
import java.util.Objects;

public class SqlAuthenticationImpl
implements SqlAuthentication {
    private final SqlClient client;
    private final SqlAuthenticationOptions options;
    private final HashingStrategy strategy = HashingStrategy.load();

    public SqlAuthenticationImpl(SqlClient client, SqlAuthenticationOptions options) {
        this.client = Objects.requireNonNull(client);
        this.options = Objects.requireNonNull(options);
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate((Credentials)new UsernamePasswordCredentials(authInfo), resultHandler);
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            UsernamePasswordCredentials authInfo = (UsernamePasswordCredentials)credentials;
            authInfo.checkValid(null);
            this.client.preparedQuery(this.options.getAuthenticationQuery()).execute(Tuple.of((Object)authInfo.getUsername()), preparedQuery -> {
                if (preparedQuery.succeeded()) {
                    RowSet rows = (RowSet)preparedQuery.result();
                    switch (rows.size()) {
                        case 0: {
                            resultHandler.handle((Object)Future.failedFuture((String)"Invalid username/password"));
                            break;
                        }
                        case 1: {
                            Row row = (Row)rows.iterator().next();
                            String hashedStoredPwd = row.getString(0);
                            if (this.strategy.verify(hashedStoredPwd, authInfo.getPassword())) {
                                resultHandler.handle((Object)Future.succeededFuture((Object)User.create((JsonObject)new JsonObject().put("username", (Object)authInfo.getUsername()))));
                                break;
                            }
                            resultHandler.handle((Object)Future.failedFuture((String)"Invalid username/password"));
                            break;
                        }
                        default: {
                            resultHandler.handle((Object)Future.failedFuture((String)"Failure in authentication"));
                            break;
                        }
                    }
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)preparedQuery.cause()));
                }
            });
        }
        catch (CredentialValidationException | ClassCastException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    @Override
    public String hash(String id, Map<String, String> params, String salt, String password) {
        return this.strategy.hash(id, params, salt, password);
    }
}

