/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.hotp;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.otp.hotp.HotpAuthOptions;
import io.vertx.ext.auth.otp.hotp.HotpCredentialsConverter;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class HotpCredentials
implements Credentials {
    private String identifier;
    private String code;

    public HotpCredentials(JsonObject jsonObject) {
        HotpCredentialsConverter.fromJson((Iterable<Map.Entry<String, Object>>)jsonObject, this);
    }

    public HotpCredentials(String identifier, String code) {
        this.identifier = identifier;
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public HotpCredentials setCode(String code) {
        this.code = code;
        return this;
    }

    public HotpCredentials setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public <V> void checkValid(V arg) throws CredentialValidationException {
        HotpAuthOptions authOptions = (HotpAuthOptions)arg;
        if (this.identifier == null || this.identifier.length() == 0) {
            throw new CredentialValidationException("identifier cannot null or empty");
        }
        if (this.code == null || this.code.length() == 0) {
            throw new CredentialValidationException("code cannot null or empty");
        }
        if (authOptions.getPasswordLength() != this.code.length()) {
            throw new CredentialValidationException("code length does not match the expected");
        }
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        HotpCredentialsConverter.toJson(this, result);
        return result;
    }
}

