/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.oauth2.OAuth2AuthorizationURL;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;

@VertxGen
public interface OAuth2Auth
extends AuthenticationProvider {
    public static OAuth2Auth create(Vertx vertx) {
        return OAuth2Auth.create(vertx, new OAuth2Options());
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2Options config) {
        return new OAuth2AuthProviderImpl(vertx, config);
    }

    public Future<Void> jWKSet();

    @Fluent
    public OAuth2Auth missingKeyHandler(Handler<String> var1);

    public String authorizeURL(OAuth2AuthorizationURL var1);

    public Future<User> refresh(User var1);

    public Future<Void> revoke(User var1, String var2);

    default public Future<Void> revoke(User user) {
        return this.revoke(user, "access_token");
    }

    public Future<JsonObject> userInfo(User var1);

    public String endSessionURL(User var1, JsonObject var2);

    default public String endSessionURL(User user) {
        return this.endSessionURL(user, new JsonObject());
    }

    public void close();
}

