/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.NoSuchKeyIdException;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2AuthorizationURL;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.Oauth2Credentials;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import java.security.SignatureException;
import java.util.Collections;

public class OAuth2AuthProviderImpl
implements OAuth2Auth,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2AuthProviderImpl.class);
    private final Vertx vertx;
    private final Context context;
    private final OAuth2Options config;
    private final OAuth2API api;
    private volatile JWT jwt = new JWT();
    private volatile long updateTimerId = -1L;
    private Handler<String> missingKeyHandler;

    public OAuth2AuthProviderImpl(Vertx vertx, OAuth2Options config) {
        this.vertx = vertx;
        this.context = vertx.getOrCreateContext();
        this.config = config;
        this.api = new OAuth2API(vertx, config);
        this.config.replaceVariables(true);
        this.config.validate();
        this.jwt.nonceAlgorithm(this.config.getJWTOptions().getNonceAlgorithm());
        if (config.getPubSecKeys() != null) {
            for (PubSecKeyOptions pubSecKey : config.getPubSecKeys()) {
                try {
                    this.jwt.addJWK(new JWK(pubSecKey));
                }
                catch (RuntimeException e) {
                    LOG.warn((Object)"Unsupported JWK", (Throwable)e);
                }
            }
        }
        if (config.getJwks() != null) {
            for (JsonObject jwk : config.getJwks()) {
                try {
                    this.jwt.addJWK(new JWK(jwk));
                }
                catch (RuntimeException e) {
                    LOG.warn((Object)"Unsupported JWK", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        OAuth2AuthProviderImpl oAuth2AuthProviderImpl = this;
        synchronized (oAuth2AuthProviderImpl) {
            if (this.updateTimerId != -1L) {
                this.vertx.cancelTimer(this.updateTimerId);
                ((VertxInternal)this.vertx).removeCloseHook((Closeable)this);
                this.updateTimerId = -1L;
            }
            this.jwt = null;
        }
    }

    @Override
    public Future<Void> jWKSet() {
        return this.api.jwkSet().compose(json -> {
            OAuth2AuthProviderImpl oAuth2AuthProviderImpl = this;
            synchronized (oAuth2AuthProviderImpl) {
                if (this.updateTimerId != -1L) {
                    this.vertx.cancelTimer(this.updateTimerId);
                    ((VertxInternal)this.vertx).removeCloseHook((Closeable)this);
                }
                JWT jwt = new JWT().nonceAlgorithm(this.config.getJWTOptions().getNonceAlgorithm());
                JsonArray keys = json.getJsonArray("keys");
                for (Object key : keys) {
                    try {
                        jwt.addJWK(new JWK((JsonObject)key));
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Unsupported JWK", (Throwable)e);
                    }
                }
                this.jwt = jwt;
                int leeway = Math.max(0, this.config.getJWTOptions().getLeeway());
                long delay = json.getLong("maxAge", Long.valueOf(this.config.getJwkMaxAgeInSeconds())) * 1000L - (long)leeway;
                if (delay > 0L) {
                    this.updateTimerId = this.vertx.setPeriodic(delay, t -> this.jWKSet().onFailure(err -> LOG.warn((Object)"Failed to auto-update JWK Set", err)));
                    ((VertxInternal)this.vertx).addCloseHook((Closeable)this);
                } else {
                    this.updateTimerId = -1L;
                }
            }
            return Future.succeededFuture();
        });
    }

    @Override
    public OAuth2Auth missingKeyHandler(Handler<String> handler) {
        this.missingKeyHandler = handler;
        return this;
    }

    public OAuth2Options getConfig() {
        return this.config;
    }

    public Future<User> authenticate(Credentials credentials) {
        try {
            if (credentials instanceof UsernamePasswordCredentials) {
                UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)credentials;
                usernamePasswordCredentials.checkValid(null);
                Oauth2Credentials cred = new Oauth2Credentials().setUsername(usernamePasswordCredentials.getUsername()).setPassword(usernamePasswordCredentials.getPassword()).setFlow(OAuth2FlowType.PASSWORD);
                return this.authenticate(cred);
            }
            if (credentials instanceof TokenCredentials) {
                JWTOptions jwtOptions;
                TokenCredentials tokenCredentials = (TokenCredentials)credentials;
                tokenCredentials.checkValid(null);
                User user = this.createUser(new JsonObject().put("access_token", (Object)tokenCredentials.getToken()), false);
                if (!user.principal().getBoolean("opaque", Boolean.valueOf(false)).booleanValue() && user.attributes().containsKey("accessToken") && !user.expired((jwtOptions = this.config.getJWTOptions()).getLeeway())) {
                    return Future.succeededFuture((Object)user);
                }
                if (this.config.getIntrospectionPath() == null) {
                    if (this.config.getUserInfoPath() == null) {
                        if (user.attributes().containsKey("missing-kid")) {
                            return Future.failedFuture((Throwable)new NoSuchKeyIdException(user.attributes().getString("missing-kid")));
                        }
                        return Future.failedFuture((String)"Can't authenticate access_token: Provider doesn't support token introspection or userinfo");
                    }
                    return this.api.userInfo(tokenCredentials.getToken(), this.jwt).compose(json -> {
                        if (json.containsKey("active") && !json.getBoolean("active", Boolean.valueOf(false)).booleanValue()) {
                            return Future.failedFuture((String)"Inactive Token");
                        }
                        User newUser = this.createUser(new JsonObject().put("access_token", (Object)tokenCredentials.getToken()), user.attributes().containsKey("missing-kid"));
                        newUser.attributes().put("idToken", json);
                        OAuth2AuthProviderImpl.copyProperties(json, user.attributes(), false, "sub", "name", "email", "picture");
                        OAuth2AuthProviderImpl.copyProperties(json, user.principal(), true, "amr");
                        if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                            return Future.failedFuture((String)"User token is expired.");
                        }
                        return Future.succeededFuture((Object)newUser);
                    });
                }
                return this.api.tokenIntrospection("access_token", tokenCredentials.getToken()).compose(json -> {
                    User newUser;
                    String clientId;
                    if (json.containsKey("active") && !json.getBoolean("active", Boolean.valueOf(false)).booleanValue()) {
                        return Future.failedFuture((String)"Inactive Token");
                    }
                    if (json.containsKey("client_id") && (clientId = this.config.getClientId()) != null && !clientId.equals(json.getString("client_id"))) {
                        LOG.info((Object)"Introspected client_id doesn't match configured client_id");
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)String.format("Introspected client_id: %s", clientId));
                            LOG.debug((Object)String.format("Configured client_id: %s", json.getString("client_id")));
                        }
                    }
                    if ((newUser = this.createUser(json.put("access_token", (Object)tokenCredentials.getToken()), user.attributes().containsKey("missing-kid"))).expired(this.config.getJWTOptions().getLeeway())) {
                        return Future.failedFuture((String)"User token is expired.");
                    }
                    return Future.succeededFuture((Object)newUser);
                });
            }
            Oauth2Credentials oauth2Credentials = (Oauth2Credentials)credentials;
            oauth2Credentials.checkValid(this.config.getSupportedGrantTypes());
            OAuth2FlowType flow = oauth2Credentials.getFlow();
            if (this.config.getSupportedGrantTypes() != null && !this.config.getSupportedGrantTypes().isEmpty() && !this.config.getSupportedGrantTypes().contains(flow.getGrantType())) {
                return Future.failedFuture((String)"Provided flow is not supported by provider");
            }
            JsonObject params = new JsonObject();
            switch (flow) {
                case AUTH_CODE: {
                    params.put("code", (Object)oauth2Credentials.getCode());
                    if (oauth2Credentials.getRedirectUri() != null) {
                        params.put("redirect_uri", (Object)oauth2Credentials.getRedirectUri());
                    }
                    if (oauth2Credentials.getCodeVerifier() == null) break;
                    params.put("code_verifier", (Object)oauth2Credentials.getCodeVerifier());
                    break;
                }
                case PASSWORD: {
                    params.put("username", (Object)oauth2Credentials.getUsername()).put("password", (Object)oauth2Credentials.getPassword());
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.config.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                case CLIENT: {
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.config.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                case AUTH_JWT: {
                    params.put("assertion", (Object)this.jwt.sign(oauth2Credentials.getJwt().copy(), this.config.getJWTOptions()));
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.config.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                case AAD_OBO: {
                    params.put("requested_token_use", (Object)"on_behalf_of").put("assertion", (Object)oauth2Credentials.getAssertion());
                    if (oauth2Credentials.getScopes() == null) break;
                    params.put("scope", (Object)String.join((CharSequence)this.config.getScopeSeparator(), oauth2Credentials.getScopes()));
                    break;
                }
                default: {
                    return Future.failedFuture((String)"Current flow does not allow acquiring a token by the replay party");
                }
            }
            return this.api.token(flow.getGrantType(), params).compose(json -> {
                User newUser = this.createUser((JsonObject)json, false);
                if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                    return Future.failedFuture((String)"User token is expired.");
                }
                return Future.succeededFuture((Object)newUser);
            });
        }
        catch (CredentialValidationException | ClassCastException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    @Override
    public String authorizeURL(OAuth2AuthorizationURL url) {
        return this.api.authorizeURL(url);
    }

    @Override
    public Future<User> refresh(User user) {
        if (user.principal().getString("refresh_token") == null || user.principal().getString("refresh_token").isEmpty()) {
            return Future.failedFuture((Throwable)new IllegalStateException("refresh_token is null or empty"));
        }
        return this.api.token("refresh_token", new JsonObject().put("refresh_token", (Object)user.principal().getString("refresh_token"))).compose(json -> {
            User newUser = this.createUser((JsonObject)json, false);
            if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                return Future.failedFuture((String)"User token is expired.");
            }
            return Future.succeededFuture((Object)newUser);
        });
    }

    @Override
    public Future<Void> revoke(User user, String tokenType) {
        return this.api.tokenRevocation(tokenType, user.principal().getString(tokenType));
    }

    @Override
    public Future<JsonObject> userInfo(User user) {
        return this.api.userInfo(user.principal().getString("access_token"), this.jwt).compose(json -> {
            String userSub = user.principal().getString("sub", user.attributes().getString("sub"));
            String userInfoSub = json.getString("sub");
            if (!(userSub == null && userInfoSub == null || userSub == null || userInfoSub == null || userSub.equals(userInfoSub))) {
                return Future.failedFuture((String)"Used 'sub' does not match UserInfo 'sub'.");
            }
            OAuth2AuthProviderImpl.copyProperties(json, user.attributes(), true, new String[0]);
            if (user.expired(this.config.getJWTOptions().getLeeway())) {
                return Future.failedFuture((String)"User token is expired.");
            }
            return Future.succeededFuture((Object)json);
        });
    }

    @Override
    public String endSessionURL(User user, JsonObject params) {
        return this.api.endSessionURL(user.principal().getString("id_token"), params);
    }

    private User createUser(JsonObject json, boolean skipMissingKeyNotify) {
        User user = User.create((JsonObject)json);
        long now = System.currentTimeMillis() / 1000L;
        String missingKid = null;
        if (json.containsKey("expires_in")) {
            Long expiresIn;
            try {
                expiresIn = json.getLong("expires_in");
            }
            catch (ClassCastException e) {
                expiresIn = Long.valueOf(json.getString("expires_in"));
            }
            user.attributes().put("iat", (Object)now).put("exp", (Object)(now + expiresIn));
        }
        if (!this.jwt.isUnsecure()) {
            JsonObject token;
            if (json.containsKey("access_token")) {
                try {
                    token = this.jwt.decode(json.getString("access_token"));
                    user.attributes().put("accessToken", (Object)this.validToken(token, false));
                    OAuth2AuthProviderImpl.copyProperties(user.attributes().getJsonObject("accessToken"), user.attributes(), true, "exp", "iat", "nbf", "sub");
                    user.attributes().put("rootClaim", (Object)"accessToken");
                    if (token.containsKey("scope")) {
                        user.principal().put("scope", (Object)token.getString("scope"));
                    }
                }
                catch (DecodeException | IllegalArgumentException e) {
                    user.principal().put("opaque", (Object)true);
                }
                catch (NoSuchKeyIdException e) {
                    user.principal().put("opaque", (Object)true);
                    if (!skipMissingKeyNotify) {
                        user.attributes().put("missing-kid", (Object)e.id());
                        missingKid = e.id();
                        if (this.missingKeyHandler != null) {
                            this.context.runOnContext(v -> this.missingKeyHandler.handle((Object)e.id()));
                        }
                    }
                }
                catch (IllegalStateException | SignatureException e) {
                    LOG.trace((Object)"Invalid JWT access_token:", (Throwable)e);
                }
            }
            if (json.containsKey("id_token")) {
                try {
                    token = this.jwt.decode(json.getString("id_token"));
                    user.attributes().put("idToken", (Object)this.validToken(token, true));
                    OAuth2AuthProviderImpl.copyProperties(user.attributes().getJsonObject("idToken"), user.attributes(), false, "sub", "name", "email", "picture");
                    OAuth2AuthProviderImpl.copyProperties(user.attributes().getJsonObject("idToken"), user.principal(), true, "amr");
                }
                catch (NoSuchKeyIdException e) {
                    if (!skipMissingKeyNotify && !e.id().equals(missingKid)) {
                        user.attributes().put("missing-kid", (Object)e.id());
                        if (this.missingKeyHandler != null) {
                            this.context.runOnContext(v -> this.missingKeyHandler.handle((Object)e.id()));
                        }
                    }
                }
                catch (DecodeException | IllegalArgumentException | IllegalStateException | SignatureException e) {
                    LOG.trace((Object)"Invalid JWT id_token:", e);
                }
            }
        } else {
            user.principal().put("opaque", (Object)true);
        }
        return user;
    }

    private JsonObject validToken(JsonObject token, boolean idToken) throws IllegalStateException {
        JWTOptions jwtOptions = this.config.getJWTOptions();
        JsonArray target = null;
        if (token.containsKey("aud")) {
            try {
                target = token.getValue("aud") instanceof String ? new JsonArray().add(token.getValue("aud")) : token.getJsonArray("aud");
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("User audience isn't a JsonArray or String");
            }
        }
        if (target != null && !target.isEmpty()) {
            if (idToken || jwtOptions.getAudience() == null) {
                if (!target.contains((Object)this.config.getClientId())) {
                    throw new IllegalStateException("Invalid JWT audience. expected: " + this.config.getClientId());
                }
            } else if (!jwtOptions.getAudience().isEmpty() && Collections.disjoint(jwtOptions.getAudience(), target.getList())) {
                throw new IllegalStateException("Invalid JWT audience. expected: " + Json.encode((Object)jwtOptions.getAudience()));
            }
        }
        if (jwtOptions.getIssuer() != null && !jwtOptions.getIssuer().equals(token.getString("iss"))) {
            throw new IllegalStateException("Invalid JWT issuer");
        }
        if (idToken && token.containsKey("azp")) {
            String clientId = this.config.getClientId();
            if (!clientId.equals(token.getString("azp"))) {
                throw new IllegalStateException("Invalid authorised party != config.clientID");
            }
            if (target != null && target.size() > 1 && !target.contains((Object)token.getString("azp"))) {
                throw new IllegalStateException("ID Token with multiple audiences, doesn't contain azp Claim value");
            }
        }
        return token;
    }

    private static void copyProperties(JsonObject source, JsonObject target, boolean overwrite, String ... keys) {
        block4: {
            if (source == null || target == null) break block4;
            if (keys.length == 0) {
                for (String key : source.fieldNames()) {
                    if (target.containsKey(key) && !overwrite) continue;
                    target.put(key, source.getValue(key));
                }
            } else {
                for (String key : keys) {
                    if (!source.containsKey(key) || target.containsKey(key) && !overwrite) continue;
                    target.put(key, source.getValue(key));
                }
            }
        }
    }

    public void close(Completable<Void> onClose) {
        this.close();
        onClose.succeed();
    }
}

