/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;

@VertxGen
public interface AppleIdAuth
extends OpenIDConnectAuth {
    public static OAuth2Auth create(Vertx vertx, String clientId, String teamId, PubSecKeyOptions privateKey) {
        return AppleIdAuth.create(vertx, clientId, teamId, privateKey, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String clientId, String teamId, PubSecKeyOptions privateKey, HttpClientOptions httpClientOptions) {
        JWT jwt = new JWT().addJWK(new JWK(privateKey));
        String clientSecret = jwt.sign(new JsonObject().put("iss", (Object)teamId).put("exp", (Object)(System.currentTimeMillis() / 1000L + 15552000L)).put("aud", (Object)"https://appleid.apple.com").put("sub", (Object)clientId), new JWTOptions().setAlgorithm("ES256").setHeader(new JsonObject().put("keyid", (Object)privateKey.getId())));
        return OAuth2Auth.create(vertx, new OAuth2Options().setHttpClientOptions(httpClientOptions).setClientId(clientId).setClientSecret(clientSecret).setSite("https://appleid.apple.com").setTokenPath("/auth/token").setRevocationPath("/auth/revoke").setAuthorizationPath("/auth/authorize").setJwkPath("/auth/keys"));
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, PubSecKeyOptions privateKey, OAuth2Options config) {
        String site = config.getSite() == null ? "https://appleid.apple.com" : config.getSite();
        JWT jwt = new JWT().addJWK(new JWK(privateKey));
        String clientSecret = jwt.sign(new JsonObject().put("iss", (Object)config.getTenant()).put("exp", (Object)(System.currentTimeMillis() / 1000L + 15552000L)).put("aud", (Object)"https://appleid.apple.com").put("sub", (Object)config.getClientId()), new JWTOptions().setAlgorithm("ES256"));
        return OpenIDConnectAuth.discover(vertx, new OAuth2Options(config).setSite(site).setClientSecret(clientSecret).setUseBasicAuthorization(false));
    }
}

