/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;

@VertxGen
public interface GitLabAuth {
    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret) {
        return GitLabAuth.create(vertx, "https://gitlab.com", clientId, clientSecret, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String site, String clientId, String clientSecret) {
        return GitLabAuth.create(vertx, site, clientId, clientSecret, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String site, String clientId, String clientSecret, HttpClientOptions httpClientOptions) {
        return OAuth2Auth.create(vertx, new OAuth2Options().setHttpClientOptions(httpClientOptions).setFlow(OAuth2FlowType.AUTH_CODE).setClientID(clientId).setClientSecret(clientSecret).setSite(site).setTokenPath("/oauth/token").setAuthorizationPath("/oauth/authorize").setUserInfoPath("/api/v4/user").setHeaders(new JsonObject().put("User-Agent", (Object)"vertx-auth-oauth2")));
    }
}

