/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;

@VertxGen
public interface AmazonCognitoAuth
extends OpenIDConnectAuth {
    public static OAuth2Auth create(Vertx vertx, String region, String clientId, String clientSecret, String guid) {
        return AmazonCognitoAuth.create(vertx, region, clientId, clientSecret, guid, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String region, String clientId, String clientSecret, String userPoolId, HttpClientOptions httpClientOptions) {
        if (region == null) {
            throw new IllegalStateException("region cannot be null");
        }
        return OAuth2Auth.create(vertx, new OAuth2Options().setHttpClientOptions(httpClientOptions).setFlow(OAuth2FlowType.AUTH_CODE).setClientID(clientId).setClientSecret(clientSecret).setTenant(userPoolId).setSite("https://cognito-idp." + region + ".amazonaws.com/{tenant}").setTokenPath("/oauth2/token").setAuthorizationPath("/oauth2/authorize").setUserInfoPath("/oauth2/userInfo").setJwkPath("/.well-known/jwks.json").setLogoutPath("/logout").setScopeSeparator("+"));
    }

    public static void discover(Vertx vertx, OAuth2Options config, Handler<AsyncResult<OAuth2Auth>> handler) {
        OpenIDConnectAuth.discover(vertx, new OAuth2Options(config).setScopeSeparator("+"), handler);
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, OAuth2Options config) {
        Promise promise = Promise.promise();
        AmazonCognitoAuth.discover(vertx, config, (Handler<AsyncResult<OAuth2Auth>>)promise);
        return promise.future();
    }
}

