/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;

@VertxGen
public interface SalesforceAuth
extends OpenIDConnectAuth {
    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret) {
        return SalesforceAuth.create(vertx, clientId, clientSecret, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) {
        return OAuth2Auth.create(vertx, new OAuth2Options().setHttpClientOptions(httpClientOptions).setFlow(OAuth2FlowType.AUTH_CODE).setClientID(clientId).setClientSecret(clientSecret).setSite("https://login.salesforce.com").setTokenPath("/services/oauth2/token").setAuthorizationPath("/services/oauth2/authorize").setScopeSeparator("+"));
    }

    public static void discover(Vertx vertx, OAuth2Options config, Handler<AsyncResult<OAuth2Auth>> handler) {
        String site = config.getSite() == null ? "https://login.salesforce.com" : config.getSite();
        OpenIDConnectAuth.discover(vertx, new OAuth2Options(config).setSite(site).setScopeSeparator("+"), handler);
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, OAuth2Options config) {
        Promise promise = Promise.promise();
        SalesforceAuth.discover(vertx, config, (Handler<AsyncResult<OAuth2Auth>>)promise);
        return promise.future();
    }
}

