/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.http.SimpleHttpClient;
import io.vertx.ext.auth.impl.http.SimpleHttpResponse;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2Options;

@VertxGen
public interface OpenIDConnectAuth {
    public static void discover(Vertx vertx, OAuth2Options config, Handler<AsyncResult<OAuth2Auth>> handler) {
        if (config.getSite() == null) {
            handler.handle((Object)Future.failedFuture((String)"issuer cannot be null"));
            return;
        }
        config.replaceVariables(false);
        SimpleHttpClient httpClient = new SimpleHttpClient(vertx, config.getUserAgent(), config.getHttpClientOptions());
        httpClient.fetch(HttpMethod.GET, config.getSite() + "/.well-known/openid-configuration", new JsonObject().put("Accept", (Object)"application/json"), null, fetch -> {
            String issuerEndpoint;
            if (fetch.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)fetch.cause()));
                return;
            }
            SimpleHttpResponse response = (SimpleHttpResponse)fetch.result();
            if (response.statusCode() != 200) {
                handler.handle((Object)Future.failedFuture((String)("Bad Response [" + response.statusCode() + "] " + response.body())));
                return;
            }
            if (!response.is("application/json")) {
                handler.handle((Object)Future.failedFuture((String)("Cannot handle Content-Type: " + response.headers().get("Content-Type"))));
                return;
            }
            JsonObject json = response.jsonObject();
            if (config.isValidateIssuer() && (issuerEndpoint = json.getString("issuer")) != null) {
                if (issuerEndpoint.endsWith("/")) {
                    issuerEndpoint = issuerEndpoint.substring(0, issuerEndpoint.length() - 1);
                }
                if (!config.getSite().equals(issuerEndpoint)) {
                    handler.handle((Object)Future.failedFuture((String)("issuer validation failed: received [" + issuerEndpoint + "]")));
                    return;
                }
            }
            config.setAuthorizationPath(json.getString("authorization_endpoint"));
            config.setTokenPath(json.getString("token_endpoint"));
            config.setLogoutPath(json.getString("end_session_endpoint"));
            config.setRevocationPath(json.getString("revocation_endpoint"));
            config.setUserInfoPath(json.getString("userinfo_endpoint"));
            config.setJwkPath(json.getString("jwks_uri"));
            try {
                OAuth2Auth oidc = OAuth2Auth.create(vertx, config);
                if (config.getJwkPath() != null) {
                    oidc.jWKSet((Handler<AsyncResult<Void>>)((Handler)v -> {
                        if (v.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)v.cause()));
                            return;
                        }
                        handler.handle((Object)Future.succeededFuture((Object)oidc));
                    }));
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)oidc));
                }
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        });
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, OAuth2Options config) {
        Promise promise = Promise.promise();
        OpenIDConnectAuth.discover(vertx, config, (Handler<AsyncResult<OAuth2Auth>>)promise);
        return promise.future();
    }
}

