/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.authorization.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class KeycloakAuthorizationImpl
implements KeycloakAuthorization {
    private static final JsonObject EMPTY_JSON = new JsonObject(Collections.EMPTY_MAP);

    public String getId() {
        return "keycloak";
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Set<Authorization>>> handler) {
        JsonObject accessToken;
        String rootClaim = user.attributes().getString("rootClaim");
        JsonObject jsonObject = accessToken = rootClaim == null ? user.principal() : user.principal().getJsonObject(rootClaim);
        if (accessToken == null) {
            handler.handle((Object)Future.failedFuture((String)"User doesn't contain a decoded Token"));
            return;
        }
        HashSet<Authorization> authorizations = new HashSet<Authorization>();
        try {
            KeycloakAuthorizationImpl.extractApplicationRoles(accessToken, authorizations);
        }
        catch (RuntimeException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
            return;
        }
        try {
            KeycloakAuthorizationImpl.extractRealmRoles(accessToken, authorizations);
        }
        catch (RuntimeException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
            return;
        }
        handler.handle((Object)Future.succeededFuture(authorizations));
    }

    private static void extractApplicationRoles(JsonObject accessToken, Set<Authorization> authorizations) {
        JsonObject resourceAccess = accessToken.getJsonObject("resource_access", EMPTY_JSON);
        for (String resource : resourceAccess.fieldNames()) {
            JsonArray appRoles = resourceAccess.getJsonObject(resource, EMPTY_JSON).getJsonArray("roles");
            if (appRoles == null || appRoles.size() < 0) continue;
            for (Object el : appRoles) {
                authorizations.add((Authorization)RoleBasedAuthorization.create((String)((String)el)).setResource(resource));
            }
        }
    }

    private static void extractRealmRoles(JsonObject accessToken, Set<Authorization> authorizations) {
        JsonArray appRoles = accessToken.getJsonObject("realm_access", EMPTY_JSON).getJsonArray("roles");
        if (appRoles != null && appRoles.size() >= 0) {
            for (Object el : appRoles) {
                authorizations.add((Authorization)RoleBasedAuthorization.create((String)((String)el)));
            }
        }
    }
}

