/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;

@VertxGen
public interface AzureADAuth
extends OpenIDConnectAuth {
    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, String guid) {
        return AzureADAuth.create(vertx, clientId, clientSecret, guid, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, String guid, HttpClientOptions httpClientOptions) {
        return OAuth2Auth.create(vertx, new OAuth2ClientOptions(httpClientOptions).setFlow(OAuth2FlowType.AUTH_CODE).setSite("https://login.windows.net/" + guid).setTokenPath("/oauth2/token").setAuthorizationPath("/oauth2/authorize").setScopeSeparator(",").setClientID(clientId).setClientSecret(clientSecret).setExtraParameters(new JsonObject().put("resource", guid)));
    }

    public static void discover(Vertx vertx, OAuth2ClientOptions config, Handler<AsyncResult<OAuth2Auth>> handler) {
        String site = config.getSite() == null ? "https://login.windows.net/common" : config.getSite();
        OpenIDConnectAuth.discover(vertx, new OAuth2ClientOptions(config).setValidateIssuer(false).setSite(site).setScopeSeparator(","), handler);
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, OAuth2ClientOptions config) {
        Promise promise = Promise.promise();
        AzureADAuth.discover(vertx, config, (Handler<AsyncResult<OAuth2Auth>>)promise);
        return promise.future();
    }
}

