/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;
import io.vertx.ext.jwt.JWTOptions;

@VertxGen
public interface GoogleAuth
extends OpenIDConnectAuth {
    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret) {
        return GoogleAuth.create(vertx, clientId, clientSecret, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) {
        return OAuth2Auth.create(vertx, new OAuth2ClientOptions(httpClientOptions).setSite("https://accounts.google.com").setFlow(OAuth2FlowType.AUTH_CODE).setTokenPath("https://www.googleapis.com/oauth2/v3/token").setAuthorizationPath("/o/oauth2/auth").setIntrospectionPath("https://www.googleapis.com/oauth2/v3/tokeninfo").setUserInfoPath("https://www.googleapis.com/oauth2/v3/userinfo").setJwkPath("https://www.googleapis.com/oauth2/v3/certs").setUserInfoParameters(new JsonObject().put("alt", "json")).setScopeSeparator(" ").setClientID(clientId).setClientSecret(clientSecret));
    }

    public static void discover(Vertx vertx, OAuth2ClientOptions config, Handler<AsyncResult<OAuth2Auth>> handler) {
        String site = config.getSite() == null ? "https://accounts.google.com" : config.getSite();
        OpenIDConnectAuth.discover(vertx, new OAuth2ClientOptions(config).setSite(site).setUserInfoParameters(new JsonObject().put("alt", "json")).setScopeSeparator(" "), handler);
    }

    public static OAuth2Auth create(Vertx vertx, JsonObject serviceAccountJson) {
        return GoogleAuth.create(vertx, serviceAccountJson, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, JsonObject serviceAccountJson, HttpClientOptions httpClientOptions) {
        StringBuilder privateKey = new StringBuilder();
        for (String s : serviceAccountJson.getString("private_key").split("\n")) {
            if ("-----BEGIN PRIVATE KEY-----".equals(s) || "-----END PRIVATE KEY-----".equals(s)) continue;
            privateKey.append(s);
        }
        return OAuth2Auth.create(vertx, new OAuth2ClientOptions(httpClientOptions).setFlow(OAuth2FlowType.AUTH_JWT).setClientID(serviceAccountJson.getString("client_id")).setSite("https://accounts.google.com").setTokenPath(serviceAccountJson.getString("token_uri")).addPubSecKey(new PubSecKeyOptions().setAlgorithm("RS256").setSecretKey(privateKey.toString())).setJWTOptions(new JWTOptions().setAlgorithm("RS256").setExpiresInMinutes(60).addAudience(serviceAccountJson.getString("token_uri")).setIssuer(serviceAccountJson.getString("client_email"))));
    }
}

