/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.auth.oauth2;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.ext.auth.oauth2.AccessToken;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth {
    public static final TypeArg<OAuth2Auth> __TYPE_ARG = new TypeArg(obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth)obj), OAuth2Auth::getDelegate);
    private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Auth that = (OAuth2Auth)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
        this.delegate = delegate;
    }

    public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
        return this.delegate;
    }

    public void verifyIsUsingPassword() {
        this.delegate.verifyIsUsingPassword();
    }

    public static OAuth2Auth createKeycloak(Vertx vertx, OAuth2FlowType flow, JsonObject config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.createKeycloak(vertx.getDelegate(), flow, config));
        return ret;
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow, OAuth2ClientOptions config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), flow, config));
        return ret;
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2FlowType flow) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), flow));
        return ret;
    }

    public String authorizeURL(JsonObject params) {
        String ret = this.delegate.authorizeURL(params);
        return ret;
    }

    public void getToken(JsonObject params, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.getToken(params, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    @Deprecated
    public Observable<AccessToken> getTokenObservable(JsonObject params) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getToken(params, (Handler<AsyncResult<AccessToken>>)handler.toHandler());
        return handler;
    }

    public Single<AccessToken> rxGetToken(JsonObject params) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.getToken(params, (Handler<AsyncResult<AccessToken>>)fut)));
    }

    public boolean hasJWTToken() {
        boolean ret = this.delegate.hasJWTToken();
        return ret;
    }

    public OAuth2Auth decodeToken(String token, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.decodeToken(token, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<AccessToken> decodeTokenObservable(String token) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.decodeToken(token, (Handler<AsyncResult<AccessToken>>)handler.toHandler());
        return handler;
    }

    public Single<AccessToken> rxDecodeToken(String token) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.decodeToken(token, (Handler<AsyncResult<AccessToken>>)fut)));
    }

    public OAuth2Auth introspectToken(String token, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.introspectToken(token, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<AccessToken> introspectTokenObservable(String token) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.introspectToken(token, (Handler<AsyncResult<AccessToken>>)handler.toHandler());
        return handler;
    }

    public Single<AccessToken> rxIntrospectToken(String token) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.introspectToken(token, (Handler<AsyncResult<AccessToken>>)fut)));
    }

    public OAuth2Auth introspectToken(String token, String tokenType, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.introspectToken(token, tokenType, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<AccessToken> introspectTokenObservable(String token, String tokenType) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.introspectToken(token, tokenType, (Handler<AsyncResult<AccessToken>>)handler.toHandler());
        return handler;
    }

    public Single<AccessToken> rxIntrospectToken(String token, String tokenType) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.introspectToken(token, tokenType, (Handler<AsyncResult<AccessToken>>)fut)));
    }

    public String getScopeSeparator() {
        String ret = this.delegate.getScopeSeparator();
        return ret;
    }

    public OAuth2FlowType getFlowType() {
        OAuth2FlowType ret = this.delegate.getFlowType();
        return ret;
    }

    public OAuth2Auth loadJWK(Handler<AsyncResult<Void>> handler) {
        this.delegate.loadJWK(handler);
        return this;
    }

    @Deprecated
    public Observable<Void> loadJWKObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.loadJWK((Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxLoadJWK() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.loadJWK((Handler<AsyncResult<Void>>)fut)));
    }

    public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
        return arg != null ? new OAuth2Auth(arg) : null;
    }
}

