/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.ext.auth.oauth2.impl.flow.AbstractOAuth2Flow;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;

public class AuthCodeImpl
extends AbstractOAuth2Flow
implements OAuth2Flow {
    public AuthCodeImpl(OAuth2AuthProviderImpl provider) {
        super(provider);
    }

    @Override
    public String authorizeURL(JsonObject params) {
        JsonObject query = params.copy();
        OAuth2ClientOptions config = this.provider.getConfig();
        if (query.containsKey("scopes")) {
            query.put("scope", String.join((CharSequence)config.getScopeSeparator(), query.getJsonArray("scopes").getList()));
            query.remove("scopes");
        }
        query.put("response_type", "code");
        query.put("client_id", config.getClientID());
        return config.getSite() + config.getAuthorizationPath() + '?' + OAuth2API.stringify(query);
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler) {
        this.getToken("authorization_code", params, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            OAuth2TokenImpl token;
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            try {
                token = new OAuth2TokenImpl(this.provider, (JsonObject)res.result());
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
                return;
            }
            handler.handle((Object)Future.succeededFuture((Object)token));
        }));
    }
}

