require 'vertx-auth-common/user'
require 'vertx/buffer'
require 'vertx-auth-oauth2/o_auth2_response'
require 'vertx-auth-common/auth_provider'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.AccessToken
module VertxAuthOauth2
  #  AccessToken extension to the User interface
  class AccessToken < ::VertxAuthCommon::User
    # @private
    # @param j_del [::VertxAuthOauth2::AccessToken] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::AccessToken] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AccessToken
    end
    def @@j_api_type.wrap(obj)
      AccessToken.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2::AccessToken.java_class
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def is_authorized(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:isAuthorized, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling is_authorized(#{arg0})"
    end
    # @param [String] authority 
    # @yield 
    # @return [self]
    def is_authorised(authority=nil)
      if authority.class == String && block_given?
        @j_del.java_method(:isAuthorised, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(authority,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling is_authorised(#{authority})"
    end
    # @return [self]
    def clear_cache
      if !block_given?
        @j_del.java_method(:clearCache, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling clear_cache()"
    end
    # @return [Hash{String => Object}]
    def principal
      if !block_given?
        return @j_del.java_method(:principal, []).call() != nil ? JSON.parse(@j_del.java_method(:principal, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling principal()"
    end
    # @param [::VertxAuthCommon::AuthProvider] arg0 
    # @return [void]
    def set_auth_provider(arg0=nil)
      if arg0.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:setAuthProvider, [Java::IoVertxExtAuth::AuthProvider.java_class]).call(arg0.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling set_auth_provider(#{arg0})"
    end
    #  Check if the access token is expired or not.
    # @return [true,false]
    def expired?
      if !block_given?
        return @j_del.java_method(:expired, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling expired?()"
    end
    #  The Access Token if present parsed as a JsonObject
    # @return [Hash{String => Object}] JSON
    def access_token
      if !block_given?
        return @j_del.java_method(:accessToken, []).call() != nil ? JSON.parse(@j_del.java_method(:accessToken, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling access_token()"
    end
    #  The Refresh Token if present parsed as a JsonObject
    # @return [Hash{String => Object}] JSON
    def refresh_token
      if !block_given?
        return @j_del.java_method(:refreshToken, []).call() != nil ? JSON.parse(@j_del.java_method(:refreshToken, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling refresh_token()"
    end
    #  The Id Token if present parsed as a JsonObject
    # @return [Hash{String => Object}] JSON
    def id_token
      if !block_given?
        return @j_del.java_method(:idToken, []).call() != nil ? JSON.parse(@j_del.java_method(:idToken, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling id_token()"
    end
    # @return [String]
    def opaque_access_token
      if !block_given?
        return @j_del.java_method(:opaqueAccessToken, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling opaque_access_token()"
    end
    # @return [String]
    def opaque_refresh_token
      if !block_given?
        return @j_del.java_method(:opaqueRefreshToken, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling opaque_refresh_token()"
    end
    # @return [String]
    def opaque_id_token
      if !block_given?
        return @j_del.java_method(:opaqueIdToken, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling opaque_id_token()"
    end
    # @return [String]
    def token_type
      if !block_given?
        return @j_del.java_method(:tokenType, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling token_type()"
    end
    # @param [true,false] trust 
    # @return [self]
    def set_trust_jwt(trust=nil)
      if (trust.class == TrueClass || trust.class == FalseClass) && !block_given?
        @j_del.java_method(:setTrustJWT, [Java::boolean.java_class]).call(trust)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_trust_jwt(#{trust})"
    end
    #  Refresh the access token
    # @yield - The callback function returning the results.
    # @return [self]
    def refresh
      if block_given?
        @j_del.java_method(:refresh, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling refresh()"
    end
    #  Revoke access or refresh token
    # @param [String] token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
    # @yield - The callback function returning the results.
    # @return [self]
    def revoke(token_type=nil)
      if token_type.class == String && block_given?
        @j_del.java_method(:revoke, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(token_type,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling revoke(#{token_type})"
    end
    #  Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
    #  available on all providers.
    # @yield - The callback function returning the results.
    # @return [self]
    def logout
      if block_given?
        @j_del.java_method(:logout, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling logout()"
    end
    #  Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
    # @param [String] tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
    # @yield - The callback function returning the results.
    # @return [self]
    def introspect(tokenType=nil)
      if block_given? && tokenType == nil
        @j_del.java_method(:introspect, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      elsif tokenType.class == String && block_given?
        @j_del.java_method(:introspect, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(tokenType,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling introspect(#{tokenType})"
    end
    #  Load the user info as per OIDC spec.
    # @yield - The callback function returning the results.
    # @return [self]
    def user_info
      if block_given?
        @j_del.java_method(:userInfo, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling user_info()"
    end
    #  Fetches a JSON resource using this Access Token.
    # @overload fetch(resource,callback)
    #   @param [String] resource - the resource to fetch.
    #   @yield - The callback function returning the results.
    # @overload fetch(method,resource,headers,payload,callback)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method - the HTTP method to user.
    #   @param [String] resource - the resource to fetch.
    #   @param [Hash{String => Object}] headers - extra headers to pass to the request.
    #   @param [::Vertx::Buffer] payload - payload to send to the server.
    #   @yield - The callback function returning the results.
    # @return [self]
    def fetch(param_1=nil,param_2=nil,param_3=nil,param_4=nil)
      if param_1.class == String && block_given? && param_2 == nil && param_3 == nil && param_4 == nil
        @j_del.java_method(:fetch, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::OAuth2Response) : nil) }))
        return self
      elsif param_1.class == Symbol && param_2.class == String && param_3.class == Hash && param_4.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:fetch, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2,::Vertx::Util::Utils.to_json_object(param_3),param_4.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::OAuth2Response) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{param_1},#{param_2},#{param_3},#{param_4})"
    end
  end
end
