/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Response;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.ext.auth.oauth2.impl.flow.AuthCodeImpl;
import io.vertx.ext.auth.oauth2.impl.flow.AuthJWTImpl;
import io.vertx.ext.auth.oauth2.impl.flow.ClientImpl;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;
import io.vertx.ext.auth.oauth2.impl.flow.PasswordImpl;
import io.vertx.ext.jwt.JWK;
import io.vertx.ext.jwt.JWT;

public class OAuth2AuthProviderImpl
implements OAuth2Auth {
    private final Vertx vertx;
    private final OAuth2FlowType flowType;
    private final OAuth2ClientOptions config;
    private final JWT jwt = new JWT();
    private final OAuth2Flow flow;

    public OAuth2AuthProviderImpl(Vertx vertx, OAuth2FlowType flow, OAuth2ClientOptions config) {
        this.vertx = vertx;
        this.config = config;
        this.flowType = flow;
        if (config.getPubSecKeys() != null) {
            for (PubSecKeyOptions pubSecKey : config.getPubSecKeys()) {
                if (pubSecKey.isSymmetric()) {
                    this.jwt.addJWK(new JWK(pubSecKey.getAlgorithm(), pubSecKey.getPublicKey()));
                } else {
                    this.jwt.addJWK(new JWK(pubSecKey.getAlgorithm(), pubSecKey.isCertificate(), pubSecKey.getPublicKey(), pubSecKey.getSecretKey()));
                }
                config.setJWTToken(true);
            }
        }
        switch (flow) {
            case AUTH_CODE: {
                if (config.getClientID() == null || config.getClientSecret() == null || config.getSite() == null) {
                    throw new IllegalArgumentException("Configuration missing. You need to specify the client id, the client secret and the oauth2 server");
                }
                this.flow = new AuthCodeImpl(this);
                break;
            }
            case CLIENT: {
                if (config.getClientID() == null || config.getClientSecret() == null || config.getSite() == null) {
                    throw new IllegalArgumentException("Configuration missing. You need to specify the client id, the client secret and the oauth2 server");
                }
                this.flow = new ClientImpl(this);
                break;
            }
            case PASSWORD: {
                if (config.getClientID() == null || config.getClientSecret() == null || config.getSite() == null) {
                    throw new IllegalArgumentException("Configuration missing. You need to specify the client id, the client secret and the oauth2 server");
                }
                this.flow = new PasswordImpl(this);
                break;
            }
            case AUTH_JWT: {
                if (config.getPubSecKeys() == null || config.getSite() == null) {
                    throw new IllegalArgumentException("Configuration missing. You need to specify the private key, the key type and the oauth2 server");
                }
                this.flow = new AuthJWTImpl(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid oauth2 flow type: " + (Object)((Object)flow));
            }
        }
    }

    @Override
    public OAuth2Auth loadJWK(Handler<AsyncResult<Void>> handler) {
        if (this.config.getJwkPath() == null) {
            handler.handle((Object)Future.succeededFuture());
        } else {
            JsonObject headers = new JsonObject();
            headers.put("Accept", "application/json");
            OAuth2API.fetch(this, HttpMethod.GET, this.config.getJwkPath(), headers, null, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
                block14: {
                    JsonObject json;
                    if (res.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                        return;
                    }
                    OAuth2Response reply = (OAuth2Response)res.result();
                    if (reply.body() == null || reply.body().length() == 0) {
                        handler.handle((Object)Future.failedFuture((String)"No Body"));
                        return;
                    }
                    if (reply.is("application/json")) {
                        try {
                            json = reply.jsonObject();
                        }
                        catch (RuntimeException e) {
                            handler.handle((Object)Future.failedFuture((Throwable)e));
                            return;
                        }
                    } else {
                        handler.handle((Object)Future.failedFuture((String)("Cannot handle content type: " + reply.headers().get("Content-Type"))));
                        return;
                    }
                    try {
                        if (json.containsKey("error")) {
                            String description;
                            Object error = json.getValue("error");
                            if (error instanceof JsonObject) {
                                description = ((JsonObject)error).getString("message");
                            } else {
                                try {
                                    description = json.getString("error_description", json.getString("error"));
                                }
                                catch (RuntimeException e) {
                                    description = error.toString();
                                }
                            }
                            handler.handle((Object)Future.failedFuture((String)description));
                            break block14;
                        }
                        JsonArray keys = json.getJsonArray("keys");
                        for (Object key : keys) {
                            this.jwt.addJWK(new JWK((JsonObject)key));
                        }
                        this.config.setJWTToken(true);
                        handler.handle((Object)Future.succeededFuture());
                    }
                    catch (RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                    }
                }
            }));
        }
        return this;
    }

    public OAuth2ClientOptions getConfig() {
        return this.config;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public JWT getJWT() {
        return this.jwt;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        this.flow.getToken(authInfo, (Handler<AsyncResult<AccessToken>>)((Handler)getToken -> {
            if (getToken.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)getToken.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)getToken.result()));
            }
        }));
    }

    @Override
    public String authorizeURL(JsonObject params) {
        return this.flow.authorizeURL(params);
    }

    @Override
    public void getToken(JsonObject credentials, Handler<AsyncResult<AccessToken>> handler) {
        this.flow.getToken(credentials, handler);
    }

    @Override
    public boolean hasJWTToken() {
        return this.config.isJWTToken();
    }

    @Override
    public OAuth2Auth decodeToken(String token, Handler<AsyncResult<AccessToken>> handler) {
        try {
            handler.handle((Object)Future.succeededFuture((Object)new OAuth2TokenImpl(this, new JsonObject().put("access_token", token))));
        }
        catch (RuntimeException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
        return this;
    }

    @Override
    public OAuth2Auth introspectToken(String token, String tokenType, Handler<AsyncResult<AccessToken>> handler) {
        try {
            OAuth2TokenImpl accessToken = new OAuth2TokenImpl(this, new JsonObject().put(tokenType, token));
            if (accessToken.expired()) {
                handler.handle((Object)Future.failedFuture((String)"Expired token"));
                return this;
            }
            accessToken.introspect((Handler<AsyncResult<Void>>)((Handler)introspect -> {
                if (introspect.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)introspect.cause()));
                    return;
                }
                if (accessToken.expired()) {
                    handler.handle((Object)Future.failedFuture((String)"Expired token"));
                    return;
                }
                handler.handle((Object)Future.succeededFuture((Object)accessToken));
            }));
        }
        catch (RuntimeException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
        return this;
    }

    @Override
    public String getScopeSeparator() {
        String sep = this.config.getScopeSeparator();
        return sep == null ? " " : sep;
    }

    @Override
    public OAuth2FlowType getFlowType() {
        return this.flowType;
    }

    public OAuth2Flow getFlow() {
        return this.flow;
    }
}

