/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.auth.oauth2;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2Response;

@RxGen(value=io.vertx.ext.auth.oauth2.AccessToken.class)
public class AccessToken
extends User {
    public static final TypeArg<AccessToken> __TYPE_ARG = new TypeArg(obj -> new AccessToken((io.vertx.ext.auth.oauth2.AccessToken)obj), AccessToken::getDelegate);
    private final io.vertx.ext.auth.oauth2.AccessToken delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)((Object)o);
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
        super((io.vertx.ext.auth.User)delegate);
        this.delegate = delegate;
    }

    public io.vertx.ext.auth.oauth2.AccessToken getDelegate() {
        return this.delegate;
    }

    public boolean expired() {
        boolean ret = this.delegate.expired();
        return ret;
    }

    public JsonObject accessToken() {
        JsonObject ret = this.delegate.accessToken();
        return ret;
    }

    public JsonObject refreshToken() {
        JsonObject ret = this.delegate.refreshToken();
        return ret;
    }

    public JsonObject idToken() {
        JsonObject ret = this.delegate.idToken();
        return ret;
    }

    public String opaqueAccessToken() {
        String ret = this.delegate.opaqueAccessToken();
        return ret;
    }

    public String opaqueRefreshToken() {
        String ret = this.delegate.opaqueRefreshToken();
        return ret;
    }

    public String opaqueIdToken() {
        String ret = this.delegate.opaqueIdToken();
        return ret;
    }

    public String tokenType() {
        String ret = this.delegate.tokenType();
        return ret;
    }

    public AccessToken setTrustJWT(boolean trust) {
        this.delegate.setTrustJWT(trust);
        return this;
    }

    public AccessToken refresh(Handler<AsyncResult<Void>> callback) {
        this.delegate.refresh(callback);
        return this;
    }

    public Completable rxRefresh() {
        return new AsyncResultCompletable(handler -> this.refresh((Handler<AsyncResult<Void>>)handler));
    }

    public AccessToken revoke(String token_type, Handler<AsyncResult<Void>> callback) {
        this.delegate.revoke(token_type, callback);
        return this;
    }

    public Completable rxRevoke(String token_type) {
        return new AsyncResultCompletable(handler -> this.revoke(token_type, (Handler<AsyncResult<Void>>)handler));
    }

    public AccessToken logout(Handler<AsyncResult<Void>> callback) {
        this.delegate.logout(callback);
        return this;
    }

    public Completable rxLogout() {
        return new AsyncResultCompletable(handler -> this.logout((Handler<AsyncResult<Void>>)handler));
    }

    public AccessToken introspect(Handler<AsyncResult<Void>> callback) {
        this.delegate.introspect(callback);
        return this;
    }

    public Completable rxIntrospect() {
        return new AsyncResultCompletable(handler -> this.introspect((Handler<AsyncResult<Void>>)handler));
    }

    public AccessToken introspect(String tokenType, Handler<AsyncResult<Void>> callback) {
        this.delegate.introspect(tokenType, callback);
        return this;
    }

    public Completable rxIntrospect(String tokenType) {
        return new AsyncResultCompletable(handler -> this.introspect(tokenType, (Handler<AsyncResult<Void>>)handler));
    }

    public AccessToken userInfo(Handler<AsyncResult<JsonObject>> callback) {
        this.delegate.userInfo(callback);
        return this;
    }

    public Single<JsonObject> rxUserInfo() {
        return new AsyncResultSingle(handler -> this.userInfo((Handler<AsyncResult<JsonObject>>)handler));
    }

    public AccessToken fetch(String resource, final Handler<AsyncResult<OAuth2Response>> callback) {
        this.delegate.fetch(resource, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<OAuth2Response> rxFetch(String resource) {
        return new AsyncResultSingle(handler -> this.fetch(resource, (Handler<AsyncResult<OAuth2Response>>)handler));
    }

    public AccessToken fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload, final Handler<AsyncResult<OAuth2Response>> callback) {
        this.delegate.fetch(method, resource, headers, payload.getDelegate(), new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<OAuth2Response> rxFetch(HttpMethod method, String resource, JsonObject headers, Buffer payload) {
        return new AsyncResultSingle(handler -> this.fetch(method, resource, headers, payload, (Handler<AsyncResult<OAuth2Response>>)handler));
    }

    public static AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
        return arg != null ? new AccessToken(arg) : null;
    }
}

