/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;

@VertxGen
public interface GoogleAuth {
    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret) {
        return GoogleAuth.create(vertx, clientId, clientSecret, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String clientId, String clientSecret, HttpClientOptions httpClientOptions) {
        return OAuth2Auth.create(vertx, OAuth2FlowType.AUTH_CODE, new OAuth2ClientOptions(httpClientOptions).setSite("https://accounts.google.com").setTokenPath("https://www.googleapis.com/oauth2/v3/token").setAuthorizationPath("/o/oauth2/auth").setIntrospectionPath("https://www.googleapis.com/oauth2/v3/tokeninfo").setUserInfoPath("https://www.googleapis.com/oauth2/v3/userinfo").setUserInfoParameters(new JsonObject().put("alt", "json")).setScopeSeparator(" ").setClientID(clientId).setClientSecret(clientSecret));
    }

    public static OAuth2Auth create(Vertx vertx, JsonObject serviceAccountJson) {
        return GoogleAuth.create(vertx, serviceAccountJson, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, JsonObject serviceAccountJson, HttpClientOptions httpClientOptions) {
        StringBuilder privateKey = new StringBuilder();
        for (String s : serviceAccountJson.getString("private_key").split("\n")) {
            if ("-----BEGIN PRIVATE KEY-----".equals(s) || "-----END PRIVATE KEY-----".equals(s)) continue;
            privateKey.append(s);
        }
        return OAuth2Auth.create(vertx, OAuth2FlowType.AUTH_JWT, new OAuth2ClientOptions(httpClientOptions).setSite("https://accounts.google.com").setTokenPath(serviceAccountJson.getString("token_uri")).setPubSecKeyOptions(new PubSecKeyOptions().setType("RS256").setSecretKey(privateKey.toString())).setExtraParameters(new JsonObject().put("algorithm", "RS256").put("expiresInMinutes", Integer.valueOf(60)).put("audience", "https://www.googleapis.com/oauth2/v4/token").put("issuer", serviceAccountJson.getString("client_email"))));
    }
}

