/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Response;
import io.vertx.ext.auth.oauth2.impl.AccessTokenImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;
import java.io.UnsupportedEncodingException;

public class AuthJWTImpl
implements OAuth2Flow {
    private final OAuth2AuthProviderImpl provider;

    public AuthJWTImpl(OAuth2AuthProviderImpl provider) {
        this.provider = provider;
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> callback) {
        JsonObject body = new JsonObject().put("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer").put("assertion", this.provider.sign(params));
        OAuth2API.fetch(this.provider, HttpMethod.POST, this.provider.getConfig().getTokenPath(), new JsonObject().put("Content-Type", "application/x-www-form-urlencoded"), Buffer.buffer((String)OAuth2API.stringify(body)), (Handler<AsyncResult<OAuth2Response>>)((Handler)fetch -> {
            JsonObject token;
            if (fetch.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)fetch.cause()));
                return;
            }
            OAuth2Response res = (OAuth2Response)fetch.result();
            if (res.is("application/json")) {
                try {
                    token = res.jsonObject();
                }
                catch (RuntimeException e) {
                    callback.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else if (res.is("application/x-www-form-urlencoded") || res.is("text/plain")) {
                try {
                    token = OAuth2API.queryToJSON(res.body().toString());
                }
                catch (UnsupportedEncodingException | RuntimeException e) {
                    callback.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else {
                callback.handle((Object)Future.failedFuture((String)("Cannot handle Content-Type: " + res.headers().get("Content-Type"))));
                return;
            }
            callback.handle((Object)Future.succeededFuture((Object)new AccessTokenImpl(this.provider, token)));
        }));
    }
}

