/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Response;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.regex.Pattern;

public class AccessTokenImpl
extends AbstractUser
implements AccessToken {
    private static final JsonObject EMPTY_JSON = new JsonObject();
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private OAuth2AuthProviderImpl provider;
    private JsonObject token;
    private JsonObject accessToken;

    public AccessTokenImpl() {
    }

    public AccessTokenImpl(OAuth2AuthProviderImpl provider, JsonObject token) {
        this.provider = provider;
        this.token = token;
        this.init();
    }

    private void init() {
        if (this.token.containsKey("expires_in")) {
            Long expiresIn;
            try {
                expiresIn = this.token.getLong("expires_in");
            }
            catch (ClassCastException e) {
                expiresIn = Long.valueOf(this.token.getString("expires_in"));
            }
            this.token.put("expires_at", Long.valueOf(System.currentTimeMillis() + 1000L * expiresIn));
        }
        this.accessToken = null;
        if (this.provider.getConfig().isJwtToken() && this.token.containsKey("access_token")) {
            this.accessToken = this.provider.decode(this.token.getString("access_token"));
        }
        this.clearCache();
        if (this.token.containsKey("scope")) {
            Collections.addAll(this.cachedPermissions, this.token.getString("scope", "").split(Pattern.quote(this.provider.getScopeSeparator())));
        }
        if (this.token.containsKey("exp")) {
            Long exp;
            try {
                exp = this.token.getLong("exp");
            }
            catch (ClassCastException e) {
                exp = Long.valueOf(this.token.getString("exp"));
            }
            this.token.put("expires_at", Long.valueOf(1000L * exp));
        }
        this.moveProperty("exp");
        this.moveProperty("iat");
        this.moveProperty("nbf");
        this.moveProperty("sub");
        this.moveProperty("aud");
        this.moveProperty("iss");
        this.moveProperty("jti");
        this.moveProperty("permissions");
        this.moveProperty("resource_access");
        this.moveProperty("realm_access");
    }

    private void moveProperty(String name) {
        if (this.token.containsKey(name) && this.accessToken != null) {
            this.accessToken.put(name, this.token.getValue(name));
        }
    }

    @Override
    public JsonObject accessToken() {
        if (this.accessToken != null) {
            return this.accessToken.copy();
        }
        return null;
    }

    @Override
    public boolean expired() {
        long now = System.currentTimeMillis();
        if (this.token.containsKey("expires_at") && this.token.getLong("expires_at", Long.valueOf(0L)) < now) {
            return true;
        }
        now = System.currentTimeMillis() / 1000L;
        if (this.accessToken != null) {
            Long nbf;
            Long iat;
            if (this.accessToken.containsKey("exp") && now >= this.accessToken.getLong("exp")) {
                return true;
            }
            if (this.accessToken.containsKey("iat") && (iat = this.accessToken.getLong("iat")) > now) {
                return true;
            }
            if (this.accessToken.containsKey("nbf") && (nbf = this.accessToken.getLong("nbf")) > now) {
                return true;
            }
        }
        return false;
    }

    @Override
    public AccessTokenImpl refresh(Handler<AsyncResult<Void>> handler) {
        JsonObject headers = new JsonObject();
        JsonObject tmp = this.provider.getConfig().getHeaders();
        if (tmp != null) {
            headers.mergeIn(tmp);
        }
        JsonObject form = new JsonObject();
        form.put("grant_type", "refresh_token").put("refresh_token", this.token.getString("refresh_token")).put("client_id", this.provider.getConfig().getClientID());
        if (this.provider.getConfig().getClientSecretParameterName() != null) {
            form.put(this.provider.getConfig().getClientSecretParameterName(), this.provider.getConfig().getClientSecret());
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Buffer payload = Buffer.buffer((String)OAuth2API.stringify(form));
        headers.put("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
        OAuth2API.fetch(this.provider, HttpMethod.POST, this.provider.getConfig().getTokenPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            block17: {
                JsonObject json;
                if (res.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                    return;
                }
                OAuth2Response reply = (OAuth2Response)res.result();
                if (reply.body() == null || reply.body().length() == 0) {
                    handler.handle((Object)Future.failedFuture((String)"No Body"));
                    return;
                }
                if (reply.is("application/json")) {
                    try {
                        json = reply.jsonObject();
                    }
                    catch (RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                    try {
                        json = OAuth2API.queryToJSON(reply.body().toString());
                    }
                    catch (UnsupportedEncodingException | RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((String)("Cannot handle accessToken type: " + reply.headers().get("Content-Type"))));
                    return;
                }
                try {
                    if (json.containsKey("error")) {
                        String description;
                        Object error = json.getValue("error");
                        if (error instanceof JsonObject) {
                            description = ((JsonObject)error).getString("message");
                        } else {
                            try {
                                description = json.getString("error_description", json.getString("error"));
                            }
                            catch (RuntimeException e) {
                                description = error.toString();
                            }
                        }
                        handler.handle((Object)Future.failedFuture((String)description));
                        break block17;
                    }
                    OAuth2API.processNonStandardHeaders(json, reply, this.provider.getConfig().getScopeSeparator());
                    this.token = json;
                    this.init();
                    handler.handle((Object)Future.succeededFuture());
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            }
        }));
        return this;
    }

    @Override
    public AccessTokenImpl revoke(String token_type, Handler<AsyncResult<Void>> handler) {
        String tokenValue = this.token.getString(token_type);
        if (tokenValue != null) {
            JsonObject headers = new JsonObject();
            JsonObject tmp = this.provider.getConfig().getHeaders();
            if (tmp != null) {
                headers.mergeIn(tmp);
            }
            JsonObject form = new JsonObject();
            form.put("token", tokenValue).put("token_type_hint", token_type);
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            Buffer payload = Buffer.buffer((String)OAuth2API.stringify(form));
            headers.put("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
            OAuth2API.fetch(this.provider, HttpMethod.POST, this.provider.getConfig().getRevocationPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
                if (res.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                    return;
                }
                OAuth2Response reply = (OAuth2Response)res.result();
                if (reply.body() == null) {
                    handler.handle((Object)Future.failedFuture((String)"No Body"));
                    return;
                }
                this.token.remove(token_type);
                if ("access_token".equals(token_type)) {
                    this.accessToken = null;
                }
                handler.handle((Object)Future.succeededFuture());
            }));
        } else {
            handler.handle((Object)Future.failedFuture((String)("Invalid token: " + token_type)));
        }
        return this;
    }

    @Override
    public AccessTokenImpl logout(Handler<AsyncResult<Void>> callback) {
        JsonObject headers = new JsonObject();
        headers.put("Authorization", "Bearer " + this.token.getString("access_token"));
        JsonObject tmp = this.provider.getConfig().getHeaders();
        if (tmp != null) {
            headers.mergeIn(tmp);
        }
        JsonObject form = new JsonObject();
        form.put("client_id", this.provider.getConfig().getClientID());
        if (this.provider.getConfig().getClientSecretParameterName() != null) {
            form.put(this.provider.getConfig().getClientSecretParameterName(), this.provider.getConfig().getClientSecret());
        }
        form.put("refresh_token", this.token.getString("refresh_token"));
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Buffer payload = Buffer.buffer((String)OAuth2API.stringify(form));
        OAuth2API.fetch(this.provider, HttpMethod.POST, this.provider.getConfig().getLogoutPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            if (res.succeeded()) {
                this.token = null;
                this.accessToken = null;
                callback.handle((Object)Future.succeededFuture());
            } else {
                callback.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
        return this;
    }

    @Override
    public AccessToken introspect(String tokenType, Handler<AsyncResult<Void>> handler) {
        JsonObject tmp;
        JsonObject headers = new JsonObject();
        OAuth2ClientOptions config = this.provider.getConfig();
        if (config.isUseBasicAuthorizationHeader()) {
            String basic = config.getClientID() + ":" + config.getClientSecret();
            headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString(basic.getBytes()));
        }
        if ((tmp = config.getHeaders()) != null) {
            headers.mergeIn(tmp);
        }
        JsonObject form = new JsonObject().put("token", this.token.getString(tokenType)).put("token_type_hint", tokenType);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Buffer payload = Buffer.buffer((String)OAuth2API.stringify(form));
        headers.put("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
        OAuth2API.fetch(this.provider, HttpMethod.POST, config.getIntrospectionPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            block24: {
                JsonObject json;
                if (res.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                    return;
                }
                OAuth2Response reply = (OAuth2Response)res.result();
                if (reply.body() == null || reply.body().length() == 0) {
                    handler.handle((Object)Future.failedFuture((String)"No Body"));
                    return;
                }
                if (reply.is("application/json")) {
                    try {
                        json = reply.jsonObject();
                    }
                    catch (RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                    try {
                        json = OAuth2API.queryToJSON(reply.body().toString());
                    }
                    catch (UnsupportedEncodingException | RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((String)("Cannot handle accessToken type: " + reply.headers().get("Content-Type"))));
                    return;
                }
                try {
                    if (json.containsKey("error")) {
                        String description;
                        Object error = json.getValue("error");
                        if (error instanceof JsonObject) {
                            description = ((JsonObject)error).getString("message");
                        } else {
                            try {
                                description = json.getString("error_description", json.getString("error"));
                            }
                            catch (RuntimeException e) {
                                description = error.toString();
                            }
                        }
                        handler.handle((Object)Future.failedFuture((String)description));
                        break block24;
                    }
                    if (json.containsKey("active") && !json.getBoolean("active", Boolean.valueOf(false)).booleanValue()) {
                        handler.handle((Object)Future.failedFuture((String)"Inactive Token"));
                        return;
                    }
                    if (json.containsKey("client_id") && !json.getString("client_id", "").equals(config.getClientID())) {
                        handler.handle((Object)Future.failedFuture((String)"Wrong client_id"));
                        return;
                    }
                    if (json.containsKey("active") && !json.getBoolean("active", Boolean.valueOf(false)).booleanValue()) {
                        handler.handle((Object)Future.failedFuture((String)"Inactive Token"));
                        return;
                    }
                    if (json.containsKey("client_id") && !json.getString("client_id", "").equals(this.provider.getConfig().getClientID())) {
                        handler.handle((Object)Future.failedFuture((String)"Wrong client_id"));
                        return;
                    }
                    try {
                        OAuth2API.processNonStandardHeaders(json, reply, config.getScopeSeparator());
                        this.token.mergeIn(json);
                        this.init();
                        if (this.expired()) {
                            handler.handle((Object)Future.failedFuture((String)"Expired token"));
                            return;
                        }
                        handler.handle((Object)Future.succeededFuture());
                    }
                    catch (RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                    }
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            }
        }));
        return this;
    }

    @Override
    public AccessToken introspect(Handler<AsyncResult<Void>> handler) {
        return this.introspect("access_token", handler);
    }

    @Override
    public AccessToken userInfo(Handler<AsyncResult<JsonObject>> callback) {
        JsonObject extraParams = this.provider.getConfig().getUserInfoParameters();
        String path = this.provider.getConfig().getUserInfoPath();
        if (extraParams != null) {
            path = path + "?" + OAuth2API.stringify(extraParams);
        }
        OAuth2API.fetch(this.provider, HttpMethod.GET, path, new JsonObject().put("Authorization", "Bearer " + this.token.getString("access_token")), null, (Handler<AsyncResult<OAuth2Response>>)((Handler)fetch -> {
            JsonObject userInfo;
            if (fetch.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)fetch.cause()));
                return;
            }
            OAuth2Response reply = (OAuth2Response)fetch.result();
            if (reply.is("application/json")) {
                try {
                    userInfo = reply.jsonObject();
                }
                catch (RuntimeException e) {
                    callback.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                try {
                    userInfo = OAuth2API.queryToJSON(reply.body().toString());
                }
                catch (UnsupportedEncodingException | RuntimeException e) {
                    callback.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else {
                callback.handle((Object)Future.failedFuture((String)("Cannot handle Content-Type: " + reply.headers().get("Content-Type"))));
                return;
            }
            OAuth2API.processNonStandardHeaders(this.token, reply, this.provider.getConfig().getScopeSeparator());
            this.init();
            callback.handle((Object)Future.succeededFuture((Object)userInfo));
        }));
        return this;
    }

    @Override
    public AccessToken fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload, Handler<AsyncResult<OAuth2Response>> callback) {
        if (headers == null) {
            headers = new JsonObject();
        }
        headers.put("Authorization", "Bearer " + this.token.getString("access_token"));
        OAuth2API.fetch(this.provider, method, resource, headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)fetch -> {
            if (fetch.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)fetch.cause()));
                return;
            }
            callback.handle((Object)Future.succeededFuture((Object)fetch.result()));
        }));
        return this;
    }

    protected void doIsPermitted(String permission, Handler<AsyncResult<Boolean>> resultHandler) {
        if (this.expired()) {
            resultHandler.handle((Object)Future.failedFuture((String)"Expired Token"));
            return;
        }
        if (this.provider.getConfig().isJwtToken()) {
            String[] parts = permission.split(":");
            if (parts.length == 1) {
                resultHandler.handle((Object)Future.succeededFuture((Object)this.hasApplicationRole(this.provider.getConfig().getClientID(), parts[0])));
                return;
            }
            if ("realm".equals(parts[0])) {
                resultHandler.handle((Object)Future.succeededFuture((Object)this.hasRealmRole(parts[1])));
                return;
            }
            resultHandler.handle((Object)Future.succeededFuture((Object)this.hasApplicationRole(parts[0], parts[1])));
        } else {
            resultHandler.handle((Object)Future.succeededFuture((Object)false));
        }
    }

    private boolean hasApplicationRole(String appName, String roleName) {
        if (this.accessToken == null) {
            return false;
        }
        JsonObject appRoles = this.accessToken.getJsonObject("resource_access", EMPTY_JSON).getJsonObject(appName);
        if (appRoles == null) {
            return false;
        }
        return appRoles.getJsonArray("roles", EMPTY_ARRAY).contains((Object)roleName);
    }

    private boolean hasRealmRole(String roleName) {
        if (this.accessToken == null) {
            return false;
        }
        return this.accessToken.getJsonObject("realm_access", EMPTY_JSON).getJsonArray("roles", EMPTY_ARRAY).contains((Object)roleName);
    }

    public JsonObject principal() {
        return this.token;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.provider = (OAuth2AuthProviderImpl)authProvider;
    }

    public void writeToBuffer(Buffer buff) {
        super.writeToBuffer(buff);
        byte[] bytes = this.token.encode().getBytes(StandardCharsets.UTF_8);
        buff.appendInt(bytes.length);
        buff.appendBytes(bytes);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        pos = super.readFromBuffer(pos, buffer);
        int len = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.token = new JsonObject(new String(bytes, StandardCharsets.UTF_8));
        this.init();
        return pos += len;
    }
}

