/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.regex.Pattern;

public class AccessTokenImpl
extends AbstractUser
implements AccessToken {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenImpl.class);
    private static final JsonObject EMPTY_JSON = new JsonObject();
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private OAuth2AuthProviderImpl provider;
    private JsonObject token;
    private JsonObject content;

    public AccessTokenImpl() {
        log.info((Object)"You are probably serializing the OAuth2 User, OAuth2 tokens are supposed to be used in stateless servers!");
    }

    public AccessTokenImpl(OAuth2AuthProviderImpl provider, JsonObject token) {
        this.provider = provider;
        this.init(token);
    }

    private void init(JsonObject json) {
        if (json.containsKey("expires_in")) {
            Long expiresIn;
            json = json.copy();
            try {
                expiresIn = json.getLong("expires_in");
            }
            catch (ClassCastException e) {
                expiresIn = Long.valueOf(json.getString("expires_in"));
            }
            json.put("expires_at", Long.valueOf(System.currentTimeMillis() + 1000L * expiresIn));
        }
        this.token = json;
        this.content = null;
        if (this.provider.getConfig().isJwtToken() && json.containsKey("access_token")) {
            this.content = this.provider.decode(json.getString("access_token"));
        }
        this.clearCache();
        if (this.token.containsKey("scope")) {
            Collections.addAll(this.cachedPermissions, this.token.getString("scope", "").split(Pattern.quote(this.provider.getScopeSeparator())));
        }
        if (this.token.containsKey("exp")) {
            Long exp;
            try {
                exp = this.token.getLong("exp");
            }
            catch (ClassCastException e) {
                exp = Long.valueOf(this.token.getString("exp"));
            }
            this.token.put("expires_at", Long.valueOf(1000L * exp));
        }
        this.moveProperty("exp");
        this.moveProperty("iat");
        this.moveProperty("nbf");
        this.moveProperty("sub");
        this.moveProperty("aud");
        this.moveProperty("iss");
        this.moveProperty("jti");
        this.moveProperty("permissions");
        this.moveProperty("resource_access");
        this.moveProperty("realm_access");
    }

    private void moveProperty(String name) {
        if (this.token.containsKey(name)) {
            if (this.content == null) {
                this.content = new JsonObject();
            }
            this.content.put(name, this.token.remove(name));
        }
    }

    @Override
    public boolean expired() {
        long now = System.currentTimeMillis();
        if (this.token.containsKey("expires_at") && this.token.getLong("expires_at", Long.valueOf(0L)) < now) {
            return true;
        }
        now = System.currentTimeMillis() / 1000L;
        if (this.content != null) {
            Long nbf;
            Long iat;
            if (this.content.containsKey("exp") && now >= this.content.getLong("exp")) {
                return true;
            }
            if (this.content.containsKey("iat") && (iat = this.content.getLong("iat")) > now) {
                return true;
            }
            if (this.content.containsKey("nbf") && (nbf = this.content.getLong("nbf")) > now) {
                return true;
            }
        }
        return false;
    }

    @Override
    public AccessTokenImpl refresh(Handler<AsyncResult<Void>> callback) {
        JsonObject params = new JsonObject().put("grant_type", "refresh_token").put("refresh_token", this.token.getString("refresh_token"));
        OAuth2API.api(this.provider, HttpMethod.POST, this.provider.getConfig().getTokenPath(), params, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.succeeded()) {
                this.init((JsonObject)res.result());
                callback.handle((Object)Future.succeededFuture());
            } else {
                callback.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
        return this;
    }

    @Override
    public AccessTokenImpl revoke(String token_type, Handler<AsyncResult<Void>> callback) {
        String tokenValue = this.token.getString(token_type);
        if (tokenValue != null) {
            JsonObject params = new JsonObject().put("token", tokenValue).put("token_type_hint", token_type);
            OAuth2API.api(this.provider, HttpMethod.POST, this.provider.getConfig().getRevocationPath(), params, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
                if (res.succeeded()) {
                    this.token.remove(token_type);
                    if ("access_token".equals(token_type)) {
                        this.content = null;
                    }
                    callback.handle((Object)Future.succeededFuture());
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)res.cause()));
                }
            }));
        } else {
            callback.handle((Object)Future.failedFuture((String)("Invalid token: " + token_type)));
        }
        return this;
    }

    @Override
    public AccessTokenImpl logout(Handler<AsyncResult<Void>> callback) {
        JsonObject params = new JsonObject().put("access_token", this.token.getString("access_token")).put("refresh_token", this.token.getString("refresh_token"));
        OAuth2API.api(this.provider, HttpMethod.POST, this.provider.getConfig().getLogoutPath(), params, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.succeeded()) {
                this.token = null;
                this.content = null;
                callback.handle((Object)Future.succeededFuture());
            } else {
                callback.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
        return this;
    }

    @Override
    public AccessToken introspect(Handler<AsyncResult<Void>> callback) {
        JsonObject query = new JsonObject().put("token", this.token.getString("access_token")).put("authorizationHeaderOnly", Boolean.valueOf(true));
        OAuth2API.api(this.provider, HttpMethod.POST, this.provider.getConfig().getIntrospectionPath(), query, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.succeeded()) {
                try {
                    JsonObject json = (JsonObject)res.result();
                    if (json.containsKey("active") && !json.getBoolean("active", Boolean.valueOf(false)).booleanValue()) {
                        callback.handle((Object)Future.failedFuture((String)"Inactive Token"));
                        return;
                    }
                    if (json.containsKey("client_id") && !json.getString("client_id", "").equals(this.provider.getConfig().getClientID())) {
                        callback.handle((Object)Future.failedFuture((String)"Wrong client_id"));
                        return;
                    }
                    try {
                        this.init(this.token.mergeIn(json));
                        if (this.expired()) {
                            callback.handle((Object)Future.failedFuture((String)"Expired token"));
                            return;
                        }
                        callback.handle((Object)Future.succeededFuture());
                    }
                    catch (RuntimeException e) {
                        callback.handle((Object)Future.failedFuture((Throwable)e));
                    }
                }
                catch (RuntimeException e) {
                    callback.handle((Object)Future.failedFuture((Throwable)e));
                }
            } else {
                callback.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
        return this;
    }

    protected void doIsPermitted(String permission, Handler<AsyncResult<Boolean>> resultHandler) {
        if (this.expired()) {
            resultHandler.handle((Object)Future.failedFuture((String)"Expired Token"));
            return;
        }
        if (this.provider.getConfig().isJwtToken()) {
            String[] parts = permission.split(":");
            if (parts.length == 1) {
                resultHandler.handle((Object)Future.succeededFuture((Object)this.hasApplicationRole(this.provider.getConfig().getClientID(), parts[0])));
                return;
            }
            if ("realm".equals(parts[0])) {
                resultHandler.handle((Object)Future.succeededFuture((Object)this.hasRealmRole(parts[1])));
                return;
            }
            resultHandler.handle((Object)Future.succeededFuture((Object)this.hasApplicationRole(parts[0], parts[1])));
        } else {
            resultHandler.handle((Object)Future.succeededFuture((Object)false));
        }
    }

    private boolean hasApplicationRole(String appName, String roleName) {
        JsonObject appRoles = this.content.getJsonObject("resource_access", EMPTY_JSON).getJsonObject(appName);
        if (appRoles == null) {
            return false;
        }
        return appRoles.getJsonArray("roles", EMPTY_ARRAY).contains((Object)roleName);
    }

    private boolean hasRealmRole(String roleName) {
        return this.content.getJsonObject("realm_access", EMPTY_JSON).getJsonArray("roles", EMPTY_ARRAY).contains((Object)roleName);
    }

    public JsonObject principal() {
        return this.token;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.provider = (OAuth2AuthProviderImpl)authProvider;
    }

    public void writeToBuffer(Buffer buff) {
        super.writeToBuffer(buff);
        byte[] bytes = this.token.encode().getBytes(StandardCharsets.UTF_8);
        buff.appendInt(bytes.length);
        buff.appendBytes(bytes);
        bytes = this.content.encode().getBytes(StandardCharsets.UTF_8);
        buff.appendInt(bytes.length);
        buff.appendBytes(bytes);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        pos = super.readFromBuffer(pos, buffer);
        int len = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.token = new JsonObject(new String(bytes, StandardCharsets.UTF_8));
        pos += len;
        len = buffer.getInt(pos);
        bytes = buffer.getBytes(pos += 4, pos + len);
        this.content = new JsonObject(new String(bytes, StandardCharsets.UTF_8));
        return pos += len;
    }
}

