/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptionsConverter;

@DataObject(generateConverter=true)
public class OAuth2ClientOptions
extends HttpClientOptions {
    private static final String AUTHORIZATION_PATH = "/oauth/authorize";
    private static final String TOKEN_PATH = "/oauth/token";
    private static final String REVOKATION_PATH = "/oauth/revoke";
    private static final boolean USE_BASIC_AUTHORIZATION_HEADER = true;
    private static final String CLIENT_SECRET_PARAMETER_NAME = "client_secret";
    private static final boolean JWT_TOKEN = false;
    private static final String SCOPE_SEPARATOR = " ";
    private String authorizationPath;
    private String tokenPath;
    private String revocationPath;
    private String scopeSeparator;
    private String logoutPath;
    private boolean useBasicAuthorizationHeader;
    private String clientSecretParameterName;
    private String userInfoPath;
    private String introspectionPath;
    private String site;
    private String clientID;
    private String clientSecret;
    private String userAgent;
    private JsonObject headers;
    private PubSecKeyOptions pubSecKey;
    private boolean jwtToken;
    private JsonObject extraParams;

    public String getSite() {
        return this.site;
    }

    public OAuth2ClientOptions() {
        this.init();
    }

    public OAuth2ClientOptions(HttpClientOptions other) {
        super(other);
        this.init();
    }

    public OAuth2ClientOptions(OAuth2ClientOptions other) {
        super((HttpClientOptions)other);
        this.authorizationPath = other.getAuthorizationPath();
        this.tokenPath = other.getTokenPath();
        this.revocationPath = other.getRevocationPath();
        this.introspectionPath = other.getIntrospectionPath();
        this.scopeSeparator = other.getScopeSeparator();
        this.useBasicAuthorizationHeader = other.isUseBasicAuthorizationHeader();
        this.clientSecretParameterName = other.getClientSecretParameterName();
        this.site = other.getSite();
        this.clientID = other.getClientID();
        this.clientSecret = other.getClientSecret();
        this.pubSecKey = other.getPubSecKey();
        this.jwtToken = other.isJwtToken();
        this.logoutPath = other.getLogoutPath();
        JsonObject obj = other.getExtraParameters();
        this.extraParams = obj != null ? obj.copy() : null;
    }

    private void init() {
        this.authorizationPath = AUTHORIZATION_PATH;
        this.tokenPath = TOKEN_PATH;
        this.revocationPath = REVOKATION_PATH;
        this.scopeSeparator = SCOPE_SEPARATOR;
        this.useBasicAuthorizationHeader = true;
        this.clientSecretParameterName = CLIENT_SECRET_PARAMETER_NAME;
        this.jwtToken = false;
        this.extraParams = null;
    }

    public OAuth2ClientOptions(JsonObject json) {
        super(json);
        this.init();
        OAuth2ClientOptionsConverter.fromJson(json, this);
    }

    public String getAuthorizationPath() {
        return this.authorizationPath;
    }

    public OAuth2ClientOptions setAuthorizationPath(String authorizationPath) {
        this.authorizationPath = authorizationPath;
        return this;
    }

    public String getTokenPath() {
        return this.tokenPath;
    }

    public OAuth2ClientOptions setTokenPath(String tokenPath) {
        this.tokenPath = tokenPath;
        return this;
    }

    public String getRevocationPath() {
        return this.revocationPath;
    }

    public OAuth2ClientOptions setRevocationPath(String revocationPath) {
        this.revocationPath = revocationPath;
        return this;
    }

    public boolean isUseBasicAuthorizationHeader() {
        return this.useBasicAuthorizationHeader;
    }

    public OAuth2ClientOptions setUseBasicAuthorizationHeader(boolean useBasicAuthorizationHeader) {
        this.useBasicAuthorizationHeader = useBasicAuthorizationHeader;
        return this;
    }

    public String getClientSecretParameterName() {
        return this.clientSecretParameterName;
    }

    public OAuth2ClientOptions setClientSecretParameterName(String clientSecretParameterName) {
        this.clientSecretParameterName = clientSecretParameterName;
        return this;
    }

    public OAuth2ClientOptions setSite(String site) {
        this.site = site;
        return this;
    }

    public String getClientID() {
        return this.clientID;
    }

    public OAuth2ClientOptions setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public OAuth2ClientOptions setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public OAuth2ClientOptions setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public JsonObject getHeaders() {
        return this.headers;
    }

    public OAuth2ClientOptions setHeaders(JsonObject headers) {
        this.headers = headers;
        return this;
    }

    public PubSecKeyOptions getPubSecKey() {
        return this.pubSecKey;
    }

    public OAuth2ClientOptions setPubSecKeyOptions(PubSecKeyOptions pubSecKey) {
        this.pubSecKey = pubSecKey;
        return this;
    }

    public boolean isJwtToken() {
        return this.jwtToken;
    }

    public OAuth2ClientOptions setJwtToken(boolean jwtToken) {
        this.jwtToken = jwtToken;
        return this;
    }

    public String getLogoutPath() {
        return this.logoutPath;
    }

    public OAuth2ClientOptions setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
        return this;
    }

    public String getUserInfoPath() {
        return this.userInfoPath;
    }

    public OAuth2ClientOptions setUserInfoPath(String userInfoPath) {
        this.userInfoPath = userInfoPath;
        return this;
    }

    public String getScopeSeparator() {
        return this.scopeSeparator;
    }

    public OAuth2ClientOptions setScopeSeparator(String scopeSeparator) {
        this.scopeSeparator = scopeSeparator;
        return this;
    }

    public JsonObject getExtraParameters() {
        return this.extraParams;
    }

    public OAuth2ClientOptions setExtraParameters(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    public String getIntrospectionPath() {
        return this.introspectionPath;
    }

    public OAuth2ClientOptions setIntrospectionPath(String introspectionPath) {
        this.introspectionPath = introspectionPath;
        return this;
    }
}

