/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.crypto;

import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public final class TokenVerifier {
    private static final Logger log = LoggerFactory.getLogger(TokenVerifier.class);
    private static final JsonObject EMPTY_JSON = new JsonObject();
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final Signature sig;
    private final PublicKey publicKey;

    public TokenVerifier(String key) {
        if (key == null) {
            this.sig = null;
            this.publicKey = null;
        } else {
            try {
                X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.getDecoder().decode(key));
                KeyFactory kf = KeyFactory.getInstance("RSA");
                this.publicKey = kf.generatePublic(spec);
                this.sig = Signature.getInstance("SHA256withRSA");
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized JsonObject verify(String accessToken) {
        if (accessToken == null || this.sig == null || this.publicKey == null) {
            return EMPTY_JSON;
        }
        try {
            String[] segments = accessToken.split("\\.");
            if (segments.length == 3) {
                String headerSeg = segments[0];
                String payloadSeg = segments[1];
                JsonObject header = new JsonObject(new String(TokenVerifier.base64urlDecode(headerSeg), UTF8));
                if ("RS256".equals(header.getString("alg"))) {
                    String signature = segments[2];
                    String signed = headerSeg + "." + payloadSeg;
                    this.sig.initVerify(this.publicKey);
                    this.sig.update(signed.getBytes());
                    if (this.sig.verify(TokenVerifier.base64urlDecode(signature))) {
                        return new JsonObject(new String(TokenVerifier.base64urlDecode(payloadSeg), UTF8));
                    }
                    log.error((Object)"bad signature");
                } else {
                    log.error((Object)("token contains unknown alg: " + header.getString("alg")));
                }
            }
        }
        catch (RuntimeException | InvalidKeyException | SignatureException e) {
            log.error((Object)e);
        }
        return EMPTY_JSON;
    }

    private static byte[] base64urlDecode(String str) {
        return Base64.getUrlDecoder().decode(str.getBytes(UTF8));
    }
}

