/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.ldap.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.ldap.LdapAuthentication;
import io.vertx.ext.auth.ldap.LdapAuthenticationOptions;
import java.util.Hashtable;
import java.util.Objects;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LdapAuthenticationImpl
implements LdapAuthentication {
    private static final String SIMPLE_AUTHENTICATION_MECHANISM = "simple";
    private static final String FOLLOW_REFERRAL = "follow";
    private Vertx vertx;
    private LdapAuthenticationOptions authenticationOptions;

    public LdapAuthenticationImpl(Vertx vertx, LdapAuthenticationOptions authenticationOptions) {
        this.vertx = Objects.requireNonNull(vertx);
        this.authenticationOptions = Objects.requireNonNull(authenticationOptions);
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate((Credentials)new UsernamePasswordCredentials(credentials), resultHandler);
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            UsernamePasswordCredentials authInfo = (UsernamePasswordCredentials)credentials;
            authInfo.checkValid(null);
            String ldapPrincipal = this.getLdapPrincipal(authInfo.getUsername());
            this.createLdapContext(ldapPrincipal, authInfo.getPassword(), (Handler<AsyncResult<LdapContext>>)((Handler)contextResponse -> {
                if (contextResponse.succeeded()) {
                    User user = User.fromName((String)authInfo.getUsername());
                    resultHandler.handle((Object)Future.succeededFuture((Object)user));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)contextResponse.cause()));
                }
            }));
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    private void createLdapContext(String principal, String credential, Handler<AsyncResult<LdapContext>> resultHandler) {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", this.authenticationOptions.getUrl());
        if (principal != null) {
            environment.put("java.naming.security.principal", principal);
        }
        if (credential != null) {
            environment.put("java.naming.security.credentials", credential);
        }
        if (this.authenticationOptions.getAuthenticationMechanism() == null && (principal != null || credential != null)) {
            environment.put("java.naming.security.authentication", SIMPLE_AUTHENTICATION_MECHANISM);
        }
        environment.put("java.naming.referral", this.authenticationOptions.getReferral() == null ? FOLLOW_REFERRAL : this.authenticationOptions.getReferral());
        this.vertx.executeBlocking(blockingResult -> {
            try {
                InitialLdapContext context = new InitialLdapContext(environment, null);
                blockingResult.complete((Object)context);
            }
            catch (Throwable t) {
                blockingResult.fail(t);
            }
        }, resultHandler);
    }

    private String getLdapPrincipal(String principal) {
        return this.authenticationOptions.getAuthenticationQuery().replace("{0}", principal);
    }
}

