/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.SecretOptions;
import io.vertx.ext.auth.jwt.JWTAuthOptionsConverter;
import io.vertx.ext.jwt.JWTOptions;
import java.util.ArrayList;
import java.util.List;

@DataObject(generateConverter=true)
public class JWTAuthOptions {
    private static final String PERMISSIONS_CLAIM_KEY = "permissions";
    private static final JWTOptions JWT_OPTIONS = new JWTOptions();
    private String permissionsClaimKey;
    private KeyStoreOptions keyStore;
    private List<PubSecKeyOptions> pubSecKeys;
    private List<SecretOptions> secrets;
    private JWTOptions jwtOptions;

    public JWTAuthOptions() {
        this.init();
    }

    public JWTAuthOptions(JWTAuthOptions other) {
        this.permissionsClaimKey = other.getPermissionsClaimKey();
        this.keyStore = other.getKeyStore();
        this.pubSecKeys = other.getPubSecKeys();
        this.secrets = other.getSecrets();
        this.jwtOptions = other.getJWTOptions();
    }

    private void init() {
        this.permissionsClaimKey = PERMISSIONS_CLAIM_KEY;
        this.jwtOptions = JWT_OPTIONS;
    }

    public JWTAuthOptions(JsonObject json) {
        this.init();
        JWTAuthOptionsConverter.fromJson(json, this);
    }

    public String getPermissionsClaimKey() {
        return this.permissionsClaimKey;
    }

    public JWTAuthOptions setPermissionsClaimKey(String permissionsClaimKey) {
        this.permissionsClaimKey = permissionsClaimKey;
        return this;
    }

    public KeyStoreOptions getKeyStore() {
        return this.keyStore;
    }

    public JWTAuthOptions setKeyStore(KeyStoreOptions keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public List<PubSecKeyOptions> getPubSecKeys() {
        return this.pubSecKeys;
    }

    public JWTAuthOptions setPubSecKeys(List<PubSecKeyOptions> pubSecKeys) {
        this.pubSecKeys = pubSecKeys;
        return this;
    }

    public List<SecretOptions> getSecrets() {
        return this.secrets;
    }

    public JWTAuthOptions setSecrets(List<SecretOptions> secrets) {
        this.secrets = secrets;
        return this;
    }

    public JWTAuthOptions addSecret(SecretOptions secret) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<SecretOptions>();
        }
        this.secrets.add(secret);
        return this;
    }

    public JWTAuthOptions addPubSecKey(PubSecKeyOptions pubSecKey) {
        if (this.pubSecKeys == null) {
            this.pubSecKeys = new ArrayList<PubSecKeyOptions>();
        }
        this.pubSecKeys.add(pubSecKey);
        return this;
    }

    public JWTOptions getJWTOptions() {
        return this.jwtOptions;
    }

    public JWTAuthOptions setJWTOptions(JWTOptions jwtOptions) {
        this.jwtOptions = jwtOptions;
        return this;
    }
}

