/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.SecretOptions;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.jwt.JWTOptions;
import java.util.ArrayList;

public class JWTAuthOptionsConverter {
    public static void fromJson(JsonObject json, JWTAuthOptions obj) {
        ArrayList<PubSecKeyOptions> list;
        if (json.getValue("jwtOptions") instanceof JsonObject) {
            obj.setJWTOptions(new JWTOptions((JsonObject)json.getValue("jwtOptions")));
        }
        if (json.getValue("keyStore") instanceof JsonObject) {
            obj.setKeyStore(new KeyStoreOptions((JsonObject)json.getValue("keyStore")));
        }
        if (json.getValue("permissionsClaimKey") instanceof String) {
            obj.setPermissionsClaimKey((String)json.getValue("permissionsClaimKey"));
        }
        if (json.getValue("pubSecKeys") instanceof JsonArray) {
            list = new ArrayList<PubSecKeyOptions>();
            json.getJsonArray("pubSecKeys").forEach(item -> {
                if (item instanceof JsonObject) {
                    list.add(new PubSecKeyOptions((JsonObject)item));
                }
            });
            obj.setPubSecKeys(list);
        }
        if (json.getValue("secrets") instanceof JsonArray) {
            list = new ArrayList();
            json.getJsonArray("secrets").forEach(item -> {
                if (item instanceof JsonObject) {
                    list.add((PubSecKeyOptions)new SecretOptions((JsonObject)item));
                }
            });
            obj.setSecrets(list);
        }
    }

    public static void toJson(JWTAuthOptions obj, JsonObject json) {
        if (obj.getPermissionsClaimKey() != null) {
            json.put("permissionsClaimKey", obj.getPermissionsClaimKey());
        }
    }
}

