/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.SecretOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.auth.jwt.JWTOptions;
import io.vertx.ext.auth.jwt.impl.JWTUser;
import io.vertx.ext.jwt.JWT;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;

public class JWTAuthProviderImpl
implements JWTAuth {
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private final JWT jwt;
    private final String permissionsClaimKey;
    private final String issuer;
    private final List<String> audience;
    private final boolean ignoreExpiration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JWTAuthProviderImpl(Vertx vertx, JWTAuthOptions config) {
        this.permissionsClaimKey = config.getPermissionsClaimKey();
        this.issuer = config.getIssuer();
        this.audience = config.getAudience();
        this.ignoreExpiration = config.isIgnoreExpiration();
        KeyStoreOptions keyStore = config.getKeyStore();
        try {
            List<SecretOptions> secrets;
            if (keyStore != null) {
                KeyStore ks = KeyStore.getInstance(keyStore.getType());
                Class<JWTAuthProviderImpl> clazz = JWTAuthProviderImpl.class;
                synchronized (JWTAuthProviderImpl.class) {
                    Buffer keystore = vertx.fileSystem().readFileBlocking(keyStore.getPath());
                    try (ByteArrayInputStream in = new ByteArrayInputStream(keystore.getBytes());){
                        ks.load(in, keyStore.getPassword().toCharArray());
                    }
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    this.jwt = new JWT(ks, keyStore.getPassword().toCharArray());
                    return;
                }
            }
            this.jwt = new JWT();
            List<PubSecKeyOptions> keys = config.getPubSecKeys();
            if (keys != null) {
                for (PubSecKeyOptions key : keys) {
                    this.jwt.addKeyPair(key.getType(), key.getPublicKey(), key.getSecretKey());
                }
            }
            if ((secrets = config.getSecrets()) == null) return;
            for (SecretOptions secret : secrets) {
                this.jwt.addSecret(secret.getType(), secret.getSecret());
            }
            return;
        }
        catch (FileSystemException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        try {
            JsonArray target;
            Long nbf;
            Long iat;
            JsonObject payload = this.jwt.decode(authInfo.getString("jwt"));
            long now = System.currentTimeMillis() / 1000L;
            if (payload.containsKey("exp") && !this.ignoreExpiration && now >= payload.getLong("exp")) {
                resultHandler.handle((Object)Future.failedFuture((String)"Expired JWT token: exp <= now"));
                return;
            }
            if (payload.containsKey("iat") && (iat = payload.getLong("iat")) > now) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT token: iat > now"));
                return;
            }
            if (payload.containsKey("nbf") && (nbf = payload.getLong("nbf")) > now) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT token: nbf > now"));
                return;
            }
            if (this.audience != null && Collections.disjoint(this.audience, (target = payload.getValue("aud") instanceof String ? new JsonArray().add(payload.getValue("aud", (Object)"")) : payload.getJsonArray("aud", EMPTY_ARRAY)).getList())) {
                resultHandler.handle((Object)Future.failedFuture((String)("Invalid JWT audient. expected: " + Json.encode(this.audience))));
                return;
            }
            if (this.issuer != null && !this.issuer.equals(payload.getString("iss"))) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT issuer"));
                return;
            }
            resultHandler.handle((Object)Future.succeededFuture((Object)((Object)new JWTUser(payload, this.permissionsClaimKey))));
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    @Override
    public String generateToken(JsonObject claims, JWTOptions options) {
        JsonObject jsonOptions = options.toJson();
        JsonObject _claims = claims.copy();
        if (jsonOptions.containsKey("permissions") && !_claims.containsKey(this.permissionsClaimKey)) {
            _claims.put(this.permissionsClaimKey, jsonOptions.getJsonArray("permissions"));
        }
        return this.jwt.sign(_claims, jsonOptions);
    }
}

