/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.ext.auth.jwt.impl.Crypto;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;

final class CryptoSignature
implements Crypto {
    private final Signature sig;
    private final PrivateKey privateKey;
    private final X509Certificate certificate;

    CryptoSignature(String algorithm, X509Certificate certificate, PrivateKey privateKey) {
        Signature signature;
        this.certificate = certificate;
        this.privateKey = privateKey;
        try {
            signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                signature = Signature.getInstance(certificate.getSigAlgName());
            }
            catch (NoSuchAlgorithmException e1) {
                throw new RuntimeException(e);
            }
        }
        this.sig = signature;
    }

    @Override
    public synchronized byte[] sign(byte[] payload) {
        try {
            this.sig.initSign(this.privateKey);
            this.sig.update(payload);
            return this.sig.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized boolean verify(byte[] signature, byte[] payload) {
        try {
            this.sig.initVerify(this.certificate);
            this.sig.update(payload);
            return this.sig.verify(signature);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

