/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.jwt.impl.Crypto;
import io.vertx.ext.auth.jwt.impl.CryptoMac;
import io.vertx.ext.auth.jwt.impl.CryptoNone;
import io.vertx.ext.auth.jwt.impl.CryptoSignature;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;

public final class JWT {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Logger log = LoggerFactory.getLogger(JWT.class);
    private static final JsonObject EMPTY = new JsonObject();
    private final Map<String, Crypto> CRYPTO_MAP;
    private final boolean unsecure;

    public JWT(KeyStore keyStore, char[] keyStorePassword) {
        HashMap<String, Crypto> tmp = new HashMap<String, Crypto>();
        boolean bl = this.unsecure = keyStore == null;
        if (!this.unsecure) {
            for (String alg : Arrays.asList("HS256", "HS384", "HS512")) {
                try {
                    Mac mac = this.getMac(keyStore, keyStorePassword, alg);
                    if (mac != null) {
                        tmp.put(alg, new CryptoMac(mac));
                        continue;
                    }
                    log.info((Object)(alg + " not available"));
                }
                catch (RuntimeException e) {
                    log.warn((Object)(alg + " not supported"), (Throwable)e);
                }
            }
            for (String alg : Arrays.asList("RS256", "RS384", "RS512", "ES256", "ES384", "ES512")) {
                try {
                    Signature signature = this.getSignature(keyStore, keyStorePassword, alg);
                    if (signature != null) {
                        tmp.put(alg, new CryptoSignature(signature));
                        continue;
                    }
                    log.info((Object)(alg + " not available"));
                }
                catch (RuntimeException e) {
                    log.warn((Object)(alg + " not supported"));
                }
            }
        }
        tmp.put("none", new CryptoNone());
        this.CRYPTO_MAP = Collections.unmodifiableMap(tmp);
    }

    private Mac getMac(KeyStore keyStore, char[] keyStorePassword, String alias) {
        try {
            Key secretKey = keyStore.getKey(alias, keyStorePassword);
            if (secretKey == null) {
                return null;
            }
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            return mac;
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
    }

    private Signature getSignature(KeyStore keyStore, char[] keyStorePassword, String alias) {
        try {
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, keyStorePassword);
            X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
            if (privateKey == null || certificate == null) {
                return null;
            }
            Signature signature = Signature.getInstance(certificate.getSigAlgName());
            signature.initSign(privateKey);
            return signature;
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonObject decode(String token) {
        String[] segments = token.split("\\.");
        if (segments.length != 3) {
            throw new RuntimeException("Not enough or too many segments");
        }
        String headerSeg = segments[0];
        String payloadSeg = segments[1];
        String signatureSeg = segments[2];
        if ("".equals(signatureSeg) && !this.unsecure) {
            throw new RuntimeException("Signature is required");
        }
        JsonObject header = new JsonObject(new String(JWT.base64urlDecode(headerSeg), UTF8));
        JsonObject payload = new JsonObject(new String(JWT.base64urlDecode(payloadSeg), UTF8));
        Crypto crypto = this.CRYPTO_MAP.get(header.getString("alg"));
        if (crypto == null) {
            throw new RuntimeException("Algorithm not supported");
        }
        String signingInput = headerSeg + "." + payloadSeg;
        if (!crypto.verify(JWT.base64urlDecode(signatureSeg), signingInput.getBytes(UTF8))) {
            throw new RuntimeException("Signature verification failed");
        }
        return payload;
    }

    public String sign(JsonObject payload, JsonObject options) {
        Long expiresInSeconds;
        String algorithm = options.getString("algorithm", "HS256");
        Crypto crypto = this.CRYPTO_MAP.get(algorithm);
        if (crypto == null) {
            throw new RuntimeException("Algorithm not supported");
        }
        JsonObject header = new JsonObject().mergeIn(options.getJsonObject("header", EMPTY)).put("typ", "JWT").put("alg", algorithm);
        long timestamp = System.currentTimeMillis() / 1000L;
        if (!options.getBoolean("noTimestamp", Boolean.valueOf(false)).booleanValue()) {
            payload.put("iat", payload.getValue("iat", (Object)timestamp));
        }
        if ((expiresInSeconds = options.containsKey("expiresInMinutes") ? Long.valueOf(options.getLong("expiresInMinutes") * 60L) : options.getLong("expiresInSeconds")) != null) {
            payload.put("exp", Long.valueOf(timestamp + expiresInSeconds));
        }
        if (options.containsKey("audience")) {
            payload.put("aud", options.getValue("audience"));
        }
        if (options.containsKey("issuer")) {
            payload.put("iss", options.getValue("issuer"));
        }
        if (options.containsKey("subject")) {
            payload.put("sub", options.getValue("subject"));
        }
        String headerSegment = JWT.base64urlEncode(header.encode());
        String payloadSegment = JWT.base64urlEncode(payload.encode());
        String signingInput = headerSegment + "." + payloadSegment;
        String signSegment = JWT.base64urlEncode(crypto.sign(signingInput.getBytes(UTF8)));
        return headerSegment + "." + payloadSegment + "." + signSegment;
    }

    private static byte[] base64urlDecode(String str) {
        return Base64.getUrlDecoder().decode(str.getBytes(UTF8));
    }

    private static String base64urlEncode(String str) {
        return JWT.base64urlEncode(str.getBytes(UTF8));
    }

    private static String base64urlEncode(byte[] bytes) {
        return Base64.getUrlEncoder().encodeToString(bytes);
    }
}

