/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htdigest.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.auth.htdigest.HtdigestCredentials;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.impl.UserImpl;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class HtdigestAuthImpl
implements HtdigestAuth {
    private static final MessageDigest MD5;
    private final Map<String, Digest> htdigest = new HashMap<String, Digest>();
    private final String realm;

    public HtdigestAuthImpl(Vertx vertx, String htdigestFile) {
        String realm = null;
        for (String line : vertx.fileSystem().readFileBlocking(htdigestFile).toString().split("\\r?\\n")) {
            String[] parts = line.split(":");
            if (realm == null) {
                realm = parts[1];
            } else if (!realm.equals(parts[1])) {
                throw new RuntimeException("multiple realms in htdigest file not allowed.");
            }
            this.htdigest.put(parts[0], new Digest(parts[0], parts[1], parts[2]));
        }
        this.realm = realm;
    }

    @Override
    public String realm() {
        return this.realm;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate(new HtdigestCredentials(authInfo), resultHandler);
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            HtdigestCredentials authInfo = (HtdigestCredentials)credentials;
            authInfo.checkValid(null);
            if (!this.htdigest.containsKey(authInfo.getUsername())) {
                resultHandler.handle((Object)Future.failedFuture((String)"Unknown username."));
                return;
            }
            Digest credential = this.htdigest.get(authInfo.getUsername());
            if (!credential.realm.equals(authInfo.getRealm())) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid realm."));
                return;
            }
            String ha1 = "MD5-sess".equals(authInfo.getAlgorithm()) ? HtdigestAuthImpl.md5(credential.password + ":" + authInfo.getNonce() + ":" + authInfo.getCnonce()) : credential.password;
            if (authInfo.getQop() != null && !"auth".equals(authInfo.getQop())) {
                if ("auth-int".equals(authInfo.getQop())) {
                    resultHandler.handle((Object)Future.failedFuture((String)"qop: auth-int not supported."));
                    return;
                }
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid qop."));
                return;
            }
            String ha2 = HtdigestAuthImpl.md5(authInfo.getMethod() + ":" + authInfo.getUri());
            String digest = authInfo.getQop() == null ? HtdigestAuthImpl.md5(ha1 + ":" + authInfo.getNonce() + ":" + ha2) : HtdigestAuthImpl.md5(ha1 + ":" + authInfo.getNonce() + ":" + authInfo.getNc() + ":" + authInfo.getCnonce() + ":" + authInfo.getQop() + ":" + ha2);
            if (digest.equals(authInfo.getResponse())) {
                resultHandler.handle((Object)Future.succeededFuture((Object)new UserImpl(new JsonObject().put("username", (Object)credential.username).put("realm", (Object)credential.realm))));
            } else {
                resultHandler.handle((Object)Future.failedFuture((String)"Bad response"));
            }
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    private static synchronized String md5(String payload) {
        MD5.reset();
        return Codec.base16Encode((byte[])MD5.digest(payload.getBytes(StandardCharsets.UTF_8)));
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Digest {
        final String username;
        final String realm;
        final String password;

        Digest(String username, String realm, String password) {
            this.username = username;
            this.realm = realm;
            this.password = password;
        }
    }
}

