/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.ext.auth.authorization.OrAuthorization;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrAuthorizationImpl
implements OrAuthorization {
    private List<Authorization> authorizations = new ArrayList<Authorization>();

    @Override
    public OrAuthorization addAuthorization(Authorization authorization) {
        this.authorizations.add(Objects.requireNonNull(authorization));
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrAuthorizationImpl)) {
            return false;
        }
        OrAuthorizationImpl other = (OrAuthorizationImpl)obj;
        return Objects.equals(this.authorizations, other.authorizations);
    }

    @Override
    public List<Authorization> getAuthorizations() {
        return this.authorizations;
    }

    public int hashCode() {
        return Objects.hash(this.authorizations);
    }

    @Override
    public boolean match(AuthorizationContext context) {
        Objects.requireNonNull(context);
        for (Authorization authorization : this.authorizations) {
            if (!authorization.match(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean verify(Authorization otherAuthorization) {
        Objects.requireNonNull(otherAuthorization);
        if (otherAuthorization instanceof OrAuthorization) {
            return this.equals(otherAuthorization);
        }
        if (this.authorizations.size() == 1) {
            return this.authorizations.get(0).verify(otherAuthorization);
        }
        return false;
    }
}

