/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.KeyStoreOptionsConverter;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

@DataObject(generateConverter=true)
public class KeyStoreOptions {
    private static final String TYPE = KeyStore.getDefaultType();
    private String type;
    private String path;
    private String password;
    private Map<String, String> passwordProtection;

    public KeyStoreOptions() {
        this.init();
    }

    public KeyStoreOptions(KeyStoreOptions other) {
        this.type = other.getType();
        this.path = other.getPath();
        this.password = other.getPassword();
        this.passwordProtection = other.getPasswordProtection();
    }

    private void init() {
        this.type = TYPE;
    }

    public KeyStoreOptions(JsonObject json) {
        this.init();
        KeyStoreOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getType() {
        return this.type;
    }

    public KeyStoreOptions setType(String type) {
        this.type = type;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public KeyStoreOptions setPath(String path) {
        this.path = path;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public KeyStoreOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public Map<String, String> getPasswordProtection() {
        return this.passwordProtection;
    }

    public KeyStoreOptions setPasswordProtection(Map<String, String> passwordProtection) {
        this.passwordProtection = passwordProtection;
        return this;
    }

    public KeyStoreOptions putPasswordProtection(String alias, String password) {
        if (this.passwordProtection == null) {
            this.passwordProtection = new HashMap<String, String>();
        }
        this.passwordProtection.put(alias, password);
        return this;
    }
}

