/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.test;

import io.vavr.Tuple2;
import io.vavr.collection.Iterator;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import io.vavr.test.Arbitrary;
import io.vavr.test.GenModule;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface Gen<T> {
    public T apply(Random var1);

    public static <T> Gen<T> of(T t) {
        return ignored -> t;
    }

    public static <T> Gen<T> of(T seed, Function<? super T, ? extends T> next) {
        Objects.requireNonNull(next, "next is null");
        Iterator iterator = Iterator.iterate(seed, next);
        return ignored -> iterator.next();
    }

    public static Gen<Integer> choose(int min, int max) {
        if (min == max) {
            return ignored -> min;
        }
        int _min = Math.min(min, max);
        int _max = Math.max(min, max);
        return rng -> rng.nextInt(Math.abs(_max - _min) + 1) + _min;
    }

    public static Gen<Long> choose(long min, long max) {
        if (min == max) {
            return ignored -> min;
        }
        return random -> {
            double d = random.nextDouble();
            long _min = Math.min(min, max);
            long _max = Math.max(min, max);
            return (long)(d * (double)_max + (1.0 - d) * (double)_min + d);
        };
    }

    public static Gen<Double> choose(double min, double max) {
        if (Double.isInfinite(min)) {
            throw new IllegalArgumentException("min is infinite");
        }
        if (Double.isInfinite(max)) {
            throw new IllegalArgumentException("max is infinite");
        }
        if (Double.isNaN(min)) {
            throw new IllegalArgumentException("min is not a number (NaN)");
        }
        if (Double.isNaN(max)) {
            throw new IllegalArgumentException("max is not a number (NaN)");
        }
        if (min == max) {
            return ignored -> min;
        }
        return random -> {
            double d = random.nextDouble();
            double _min = Math.min(min, max);
            double _max = Math.max(min, max);
            return d * _max + (1.0 - d) * _min;
        };
    }

    public static Gen<Character> choose(char min, char max) {
        if (min == max) {
            return ignored -> Character.valueOf(min);
        }
        return Gen.choose((int)min, (int)max).map(i -> Character.valueOf((char)i.intValue()));
    }

    public static Gen<Character> choose(char ... characters) {
        Objects.requireNonNull(characters, "characters is null");
        Character[] validCharacters = (Character[])List.ofAll((char[])characters).toJavaArray(Character.class);
        return Gen.choose(validCharacters);
    }

    public static <T extends Enum<T>> Gen<T> choose(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz is null");
        return Gen.choose(clazz.getEnumConstants());
    }

    @SafeVarargs
    public static <T> Gen<T> choose(T ... values) {
        Objects.requireNonNull(values, "values is null");
        if (values.length == 0) {
            return Gen.fail("Empty array");
        }
        return Gen.choose(0, values.length - 1).map(i -> values[i]);
    }

    public static <T> Gen<T> choose(Iterable<T> values) {
        Objects.requireNonNull(values, "values is null");
        Iterator iterator = Iterator.ofAll(values);
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Empty iterable");
        }
        Object[] array = iterator.toJavaArray();
        return Gen.choose(array);
    }

    public static <T> Gen<T> fail() {
        return Gen.fail("failed");
    }

    public static <T> Gen<T> fail(String message) {
        return ignored -> {
            throw new RuntimeException(message);
        };
    }

    @SafeVarargs
    public static <T> Gen<T> frequency(Tuple2<Integer, Gen<T>> ... generators) {
        Objects.requireNonNull(generators, "generators is null");
        if (generators.length == 0) {
            throw new IllegalArgumentException("generators is empty");
        }
        Stream iterable = Stream.of((Object[])generators);
        return Gen.frequency(iterable);
    }

    public static <T> Gen<T> frequency(Iterable<Tuple2<Integer, Gen<T>>> generators) {
        Objects.requireNonNull(generators, "generators is null");
        Vector filtered = Iterator.ofAll(generators).filter(t -> (Integer)t._1() > 0).toVector();
        if (filtered.isEmpty()) {
            throw new IllegalArgumentException("no generator with positive weight");
        }
        int size = filtered.map(t -> (Integer)t._1).sum().intValue();
        return Gen.choose(1, size).flatMap(n -> GenModule.frequency(n, filtered.iterator()));
    }

    default public Gen<T> intersperse(Gen<T> other) {
        Iterator iter = Iterator.continually((Object)this).intersperse(other);
        return random -> ((Gen)iter.get()).apply(random);
    }

    @SafeVarargs
    public static <T> Gen<T> oneOf(Gen<T> ... generators) {
        Objects.requireNonNull(generators, "generators is null");
        if (generators.length == 0) {
            throw new IllegalArgumentException("generators is empty");
        }
        return Gen.choose(0, generators.length - 1).flatMap(i -> generators[i]);
    }

    public static <T> Gen<T> oneOf(Iterable<Gen<T>> generators) {
        Objects.requireNonNull(generators, "generators is null");
        Stream stream = Stream.ofAll(generators);
        if (stream.isEmpty()) {
            throw new IllegalArgumentException("generators is empty");
        }
        Gen[] array = (Gen[])stream.toJavaArray(Gen.class);
        return Gen.oneOf(array);
    }

    default public Arbitrary<T> arbitrary() {
        return n -> this;
    }

    default public Gen<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return random -> {
            T t;
            int count = 0;
            int filterThreshold = Integer.MAX_VALUE;
            while (!predicate.test((T)(t = this.apply(random)))) {
                if (++count != Integer.MAX_VALUE) continue;
                throw new IllegalStateException("empty filter");
            }
            return t;
        };
    }

    default public <U> Gen<U> flatMap(Function<? super T, ? extends Gen<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return random -> ((Gen)mapper.apply((T)this.apply(random))).apply(random);
    }

    default public <U> Gen<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return random -> mapper.apply((T)this.apply(random));
    }

    default public Gen<T> peek(Consumer<? super T> action) {
        return random -> {
            T t = this.apply(random);
            action.accept((T)t);
            return t;
        };
    }

    default public <U> U transform(Function<? super Gen<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }
}

