/*
 * Decompiled with CFR 0.152.
 */
package io.valkey;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class ExceptionHandler {
    private Map<Predicate<String>, ErrorCallback> patternCallbacks = new HashMap<Predicate<String>, ErrorCallback>();

    public void register(Predicate<String> pattern, ErrorCallback callback) {
        this.patternCallbacks.put(pattern, callback);
    }

    public void handleException(Exception e) {
        Optional.ofNullable(e.getMessage()).ifPresent(errorMessage -> this.patternCallbacks.forEach((pattern, callback) -> {
            if (pattern.test(errorMessage)) {
                callback.onError((String)errorMessage);
            }
        }));
    }

    public static interface ErrorCallback {
        public void onError(String var1);
    }
}

